/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver;

import com.google.common.base.Preconditions;
import io.prestosql.benchto.driver.Benchmark;
import io.prestosql.benchto.driver.utils.TimeUtils;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public abstract class Measurable {
    protected long start;
    protected long end;
    protected ZonedDateTime utcStart;
    protected ZonedDateTime utcEnd;

    public ZonedDateTime getUtcStart() {
        return this.utcStart;
    }

    public ZonedDateTime getUtcEnd() {
        return this.utcEnd;
    }

    public Duration getQueryDuration() {
        return Duration.of(this.end - this.start, ChronoUnit.NANOS);
    }

    public abstract Benchmark getBenchmark();

    public abstract String getEnvironment();

    public abstract boolean isSuccessful();

    public abstract String toString();

    public static abstract class MeasuredBuilder<T extends Measurable, B extends MeasuredBuilder> {
        protected final T object;

        public MeasuredBuilder(T object) {
            this.object = object;
        }

        public B startTimer() {
            ((Measurable)this.object).start = System.nanoTime();
            ((Measurable)this.object).utcStart = TimeUtils.nowUtc();
            return (B)this;
        }

        public B endTimer() {
            Preconditions.checkState((((Measurable)this.object).start > 0L ? 1 : 0) != 0, (Object)"Expected startTimer() to be called before.");
            ((Measurable)this.object).end = System.nanoTime();
            ((Measurable)this.object).utcEnd = TimeUtils.nowUtc();
            return (B)this;
        }

        public T build() {
            return this.object;
        }
    }
}

