/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prestosql.benchto.driver.execution.QueryExecution;
import io.prestosql.benchto.driver.execution.QueryExecutionResult;
import io.prestosql.benchto.driver.loader.SqlStatementGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryExecutionDriver {
    private static final Logger LOG = LoggerFactory.getLogger(QueryExecutionDriver.class);
    private static final int LOGGED_ROWS = 10;
    @Autowired
    private SqlStatementGenerator sqlStatementGenerator;

    public QueryExecutionResult execute(QueryExecution queryExecution, Connection connection) throws SQLException {
        QueryExecutionResult.QueryExecutionResultBuilder queryExecutionResultBuilder = (QueryExecutionResult.QueryExecutionResultBuilder)new QueryExecutionResult.QueryExecutionResultBuilder(queryExecution).startTimer();
        String sqlStatement = this.generateQuerySqlStatement(queryExecution);
        if (this.isSelectQuery(sqlStatement)) {
            return this.executeSelectQuery(connection, queryExecutionResultBuilder, sqlStatement);
        }
        return this.executeUpdateQuery(connection, queryExecutionResultBuilder, sqlStatement);
    }

    private boolean isSelectQuery(String sql) {
        return (sql = sql.trim().toLowerCase()).startsWith("select") || sql.startsWith("show") || sql.startsWith("with");
    }

    /*
     * Exception decompiling
     */
    private QueryExecutionResult executeSelectQuery(Connection connection, QueryExecutionResult.QueryExecutionResultBuilder queryExecutionResultBuilder, String sqlStatement) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private QueryExecutionResult executeUpdateQuery(Connection connection, QueryExecutionResult.QueryExecutionResultBuilder queryExecutionResultBuilder, String sqlStatement) throws SQLException {
        try (Statement statement = connection.createStatement();){
            int rowCount = statement.executeUpdate(sqlStatement);
            QueryExecutionResult queryExecutionResult = (QueryExecutionResult)((QueryExecutionResult.QueryExecutionResultBuilder)queryExecutionResultBuilder.setRowsCount(rowCount).endTimer()).build();
            return queryExecutionResult;
        }
    }

    private String generateQuerySqlStatement(QueryExecution queryExecution) {
        ImmutableMap variables = ImmutableMap.builder().put((Object)"execution_sequence_id", (Object)("" + queryExecution.getRun())).putAll(queryExecution.getBenchmark().getNonReservedKeywordVariables()).build();
        List<String> sqlQueries = this.sqlStatementGenerator.generateQuerySqlStatement(queryExecution.getQuery(), (Map<String, ?>)variables);
        Preconditions.checkState((sqlQueries.size() == 1 ? 1 : 0) != 0, (Object)"Multiple statements in one query file are not supported");
        return sqlQueries.get(0);
    }
}

