/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.listeners;

import io.prestosql.benchto.driver.Benchmark;
import io.prestosql.benchto.driver.execution.BenchmarkExecutionResult;
import io.prestosql.benchto.driver.execution.QueryExecution;
import io.prestosql.benchto.driver.execution.QueryExecutionResult;
import io.prestosql.benchto.driver.listeners.benchmark.BenchmarkExecutionListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoggingBenchmarkExecutionListener
implements BenchmarkExecutionListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingBenchmarkExecutionListener.class);

    public int getOrder() {
        return -100;
    }

    @Override
    public Future<?> benchmarkStarted(Benchmark benchmark) {
        LOG.info("Executing benchmark: {}", (Object)benchmark.getName());
        return CompletableFuture.completedFuture("");
    }

    @Override
    public Future<?> benchmarkFinished(BenchmarkExecutionResult result) {
        LOG.info("Finished benchmark: {}", (Object)result.getBenchmark().getName());
        return CompletableFuture.completedFuture("");
    }

    @Override
    public Future<?> executionStarted(QueryExecution execution) {
        LOG.info("Query started: {} ({}/{})", new Object[]{execution.getQueryName(), execution.getRun(), execution.getBenchmark().getRuns()});
        return CompletableFuture.completedFuture("");
    }

    @Override
    public Future<?> executionFinished(QueryExecutionResult result) {
        if (result.isSuccessful()) {
            LOG.info("Query finished: {} ({}/{}), rows count: {}, duration: {}", new Object[]{result.getQueryName(), result.getQueryExecution().getRun(), result.getBenchmark().getRuns(), result.getRowsCount(), result.getQueryDuration()});
        } else {
            LOG.error("Query failed: {} ({}/{}), execution error: {}", new Object[]{result.getQueryName(), result.getQueryExecution().getRun(), result.getBenchmark().getRuns(), result.getFailureCause().getMessage()});
        }
        return CompletableFuture.completedFuture("");
    }
}

