/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.loader;

import com.google.common.collect.Iterables;
import io.prestosql.benchto.driver.BenchmarkExecutionException;
import io.prestosql.benchto.driver.BenchmarkProperties;
import io.prestosql.benchto.driver.Query;
import io.prestosql.benchto.driver.loader.AnnotatedQueryParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryLoader {
    @Autowired
    private BenchmarkProperties properties;
    @Autowired
    private AnnotatedQueryParser annotatedQueryParser;

    public Query loadFromFile(String queryName) {
        List queryPaths = this.properties.sqlFilesDirs().stream().map(sqlFilesDir -> sqlFilesDir.resolve(queryName)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        if (queryPaths.isEmpty()) {
            throw new BenchmarkExecutionException(String.format("Could not find any SQL query file for query name: %s", queryName));
        }
        if (queryPaths.size() > 1) {
            throw new BenchmarkExecutionException(String.format("Found multiple SQL query files for query name: %s", queryName));
        }
        Path queryPath = (Path)Iterables.getOnlyElement(queryPaths);
        try {
            String queryNameWithoutExtension = com.google.common.io.Files.getNameWithoutExtension((String)queryPath.toString());
            return this.annotatedQueryParser.parseFile(queryNameWithoutExtension, queryPath);
        }
        catch (IOException e) {
            throw new BenchmarkExecutionException(String.format("Error during loading query from path %s", queryPath), e);
        }
    }

    public List<Query> loadFromFiles(List<String> queryNames) {
        return queryNames.stream().map(this::loadFromFile).collect(Collectors.toList());
    }
}

