/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.presto;

import io.prestosql.benchto.driver.Measurable;
import io.prestosql.benchto.driver.execution.QueryExecutionResult;
import io.prestosql.benchto.driver.listeners.queryinfo.QueryInfoProvider;
import io.prestosql.benchto.driver.presto.PrestoClient;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="benchmark.feature.presto", value={"queryinfo.collection.enabled"})
public class PrestoQueryInfoLoader
implements QueryInfoProvider {
    @Autowired
    private PrestoClient prestoClient;

    @Override
    public CompletableFuture<Optional<String>> loadQueryInfo(Measurable measurable) {
        QueryExecutionResult executionResult;
        if (measurable instanceof QueryExecutionResult && (executionResult = (QueryExecutionResult)measurable).getPrestoQueryId().isPresent()) {
            return CompletableFuture.completedFuture(Optional.of(this.prestoClient.getQueryInfo(executionResult.getPrestoQueryId().get())));
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }
}

