/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchto.driver.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CartesianProductUtils {
    public static <K, V> List<Map<K, V>> cartesianProduct(Map<K, List<V>> map) {
        ArrayList cartesianProducts = Lists.newArrayList();
        if (map.size() > 0) {
            CartesianProductUtils.cartesianProductRecursion(map, Lists.newArrayList(map.keySet()), 0, Maps.newHashMap(), cartesianProducts);
        }
        return cartesianProducts;
    }

    private static <K, V> void cartesianProductRecursion(Map<K, List<V>> map, List<K> keys, int index, Map<K, V> accumulator, List<Map<K, V>> cartesianProducts) {
        K key = keys.get(index);
        List<V> values = map.get(key);
        for (V value : values) {
            accumulator.put(key, value);
            if (index == keys.size() - 1) {
                cartesianProducts.add(Maps.newHashMap(accumulator));
                continue;
            }
            CartesianProductUtils.cartesianProductRecursion(map, keys, index + 1, accumulator, cartesianProducts);
        }
    }

    private CartesianProductUtils() {
    }
}

