/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.Credentials;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageCredentials;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageUri;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Base64;
import java.net.URI;

public final class StorageCredentialsAccountAndKey
extends StorageCredentials {
    private Credentials credentials;

    public StorageCredentialsAccountAndKey(String accountName, byte[] key) {
        this.credentials = new Credentials(accountName, key);
    }

    public StorageCredentialsAccountAndKey(String accountName, String key) {
        this(accountName, Base64.decode(key));
    }

    @Override
    public String getAccountName() {
        return this.credentials.getAccountName();
    }

    public String getAccountKeyName() {
        return this.credentials.getKeyName();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public String toString(boolean exportSecrets) {
        return String.format("%s=%s;%s=%s", "AccountName", this.getAccountName(), "AccountKey", exportSecrets ? this.credentials.getKey().getBase64EncodedKey() : "[key hidden]");
    }

    @Override
    public URI transformUri(URI resourceUri, OperationContext opContext) {
        return resourceUri;
    }

    @Override
    public StorageUri transformUri(StorageUri resourceUri, OperationContext opContext) {
        return resourceUri;
    }
}

