/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie;

import io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.CookieSpec;
import io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.CookieSpecBase;
import io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.NetscapeDraftSpec;
import io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.RFC2109Spec;
import io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.RFC2965Spec;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CookiePolicy {
    private static Map SPECS = Collections.synchronizedMap(new HashMap());
    public static final String BROWSER_COMPATIBILITY = "compatibility";
    public static final String NETSCAPE = "netscape";
    public static final String RFC_2109 = "rfc2109";
    public static final String RFC_2965 = "rfc2965";
    public static final String IGNORE_COOKIES = "ignoreCookies";
    public static final String DEFAULT = "default";
    public static final int COMPATIBILITY = 0;
    public static final int NETSCAPE_DRAFT = 1;
    public static final int RFC2109 = 2;
    public static final int RFC2965 = 3;
    private static int defaultPolicy;
    protected static final Log LOG;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$RFC2109Spec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$RFC2965Spec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$CookieSpecBase;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$CookiePolicy;

    public static void registerCookieSpec(String id, Class clazz) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Cookie spec class may not be null");
        }
        SPECS.put(id.toLowerCase(), clazz);
    }

    public static void unregisterCookieSpec(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SPECS.remove(id.toLowerCase());
    }

    public static CookieSpec getCookieSpec(String id) throws IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        Class clazz = (Class)SPECS.get(id.toLowerCase());
        if (clazz != null) {
            try {
                return (CookieSpec)clazz.newInstance();
            }
            catch (Exception e) {
                LOG.error("Error initializing cookie spec: " + id, e);
                throw new IllegalStateException(id + " cookie spec implemented by " + clazz.getName() + " could not be initialized");
            }
        }
        throw new IllegalStateException("Unsupported cookie spec " + id);
    }

    public static int getDefaultPolicy() {
        return defaultPolicy;
    }

    public static void setDefaultPolicy(int policy) {
        defaultPolicy = policy;
    }

    public static CookieSpec getSpecByPolicy(int policy) {
        switch (policy) {
            case 0: {
                return new CookieSpecBase();
            }
            case 1: {
                return new NetscapeDraftSpec();
            }
            case 2: {
                return new RFC2109Spec();
            }
            case 3: {
                return new RFC2965Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getDefaultSpec() {
        try {
            return CookiePolicy.getCookieSpec(DEFAULT);
        }
        catch (IllegalStateException e) {
            LOG.warn("Default cookie policy is not registered");
            return new RFC2109Spec();
        }
    }

    public static CookieSpec getSpecByVersion(int ver) {
        switch (ver) {
            case 0: {
                return new NetscapeDraftSpec();
            }
            case 1: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getCompatibilitySpec() {
        return CookiePolicy.getSpecByPolicy(0);
    }

    public static String[] getRegisteredCookieSpecs() {
        return SPECS.keySet().toArray(new String[SPECS.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CookiePolicy.registerCookieSpec(DEFAULT, class$org$apache$commons$httpclient$cookie$RFC2109Spec == null ? (class$org$apache$commons$httpclient$cookie$RFC2109Spec = CookiePolicy.class$("io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.RFC2109Spec")) : class$org$apache$commons$httpclient$cookie$RFC2109Spec);
        CookiePolicy.registerCookieSpec(RFC_2109, class$org$apache$commons$httpclient$cookie$RFC2109Spec == null ? (class$org$apache$commons$httpclient$cookie$RFC2109Spec = CookiePolicy.class$("io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.RFC2109Spec")) : class$org$apache$commons$httpclient$cookie$RFC2109Spec);
        CookiePolicy.registerCookieSpec(RFC_2965, class$org$apache$commons$httpclient$cookie$RFC2965Spec == null ? (class$org$apache$commons$httpclient$cookie$RFC2965Spec = CookiePolicy.class$("io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.RFC2965Spec")) : class$org$apache$commons$httpclient$cookie$RFC2965Spec);
        CookiePolicy.registerCookieSpec(BROWSER_COMPATIBILITY, class$org$apache$commons$httpclient$cookie$CookieSpecBase == null ? (class$org$apache$commons$httpclient$cookie$CookieSpecBase = CookiePolicy.class$("io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.CookieSpecBase")) : class$org$apache$commons$httpclient$cookie$CookieSpecBase);
        CookiePolicy.registerCookieSpec(NETSCAPE, class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec == null ? (class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec = CookiePolicy.class$("io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.NetscapeDraftSpec")) : class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec);
        CookiePolicy.registerCookieSpec(IGNORE_COOKIES, class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec == null ? (class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec = CookiePolicy.class$("io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.IgnoreCookiesSpec")) : class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec);
        defaultPolicy = 2;
        LOG = LogFactory.getLog(class$org$apache$commons$httpclient$cookie$CookiePolicy == null ? (class$org$apache$commons$httpclient$cookie$CookiePolicy = CookiePolicy.class$("io.prestosql.hadoop.$internal.org.apache.commons.httpclient.cookie.CookiePolicy")) : class$org$apache$commons$httpclient$cookie$CookiePolicy);
    }
}

