/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.http.impl.conn;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.org.apache.http.HttpException;
import io.prestosql.hadoop.$internal.org.apache.http.HttpHost;
import io.prestosql.hadoop.$internal.org.apache.http.HttpRequest;
import io.prestosql.hadoop.$internal.org.apache.http.conn.params.ConnRouteParams;
import io.prestosql.hadoop.$internal.org.apache.http.conn.routing.HttpRoute;
import io.prestosql.hadoop.$internal.org.apache.http.conn.routing.HttpRoutePlanner;
import io.prestosql.hadoop.$internal.org.apache.http.conn.scheme.Scheme;
import io.prestosql.hadoop.$internal.org.apache.http.conn.scheme.SchemeRegistry;
import java.net.InetAddress;

@.ThreadSafe
public class DefaultHttpRoutePlanner
implements HttpRoutePlanner {
    protected final SchemeRegistry schemeRegistry;

    public DefaultHttpRoutePlanner(SchemeRegistry schreg) {
        if (schreg == null) {
            throw new IllegalArgumentException("SchemeRegistry must not be null.");
        }
        this.schemeRegistry = schreg;
    }

    public HttpRoute determineRoute(HttpHost target, HttpRequest request, .HttpContext context) throws HttpException {
        Scheme schm;
        if (request == null) {
            throw new IllegalStateException("Request must not be null.");
        }
        HttpRoute route = ConnRouteParams.getForcedRoute(request.getParams());
        if (route != null) {
            return route;
        }
        if (target == null) {
            throw new IllegalStateException("Target host must not be null.");
        }
        InetAddress local = ConnRouteParams.getLocalAddress(request.getParams());
        HttpHost proxy = ConnRouteParams.getDefaultProxy(request.getParams());
        try {
            schm = this.schemeRegistry.getScheme(target.getSchemeName());
        }
        catch (IllegalStateException ex) {
            throw new HttpException(ex.getMessage());
        }
        boolean secure = schm.isLayered();
        route = proxy == null ? new HttpRoute(target, local, secure) : new HttpRoute(target, local, proxy, secure);
        return route;
    }
}

