/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import io.prestosql.hadoop.$internal.org.apache.commons.codec.digest.DigestUtils;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public abstract class TokenIdentifier
implements Writable {
    private String trackingId = null;

    public abstract Text getKind();

    public abstract UserGroupInformation getUser();

    public byte[] getBytes() {
        DataOutputBuffer buf = new DataOutputBuffer(4096);
        try {
            this.write(buf);
        }
        catch (IOException ie) {
            throw new RuntimeException("i/o error in getBytes", ie);
        }
        return Arrays.copyOf(buf.getData(), buf.getLength());
    }

    public String getTrackingId() {
        if (this.trackingId == null) {
            this.trackingId = DigestUtils.md5Hex(this.getBytes());
        }
        return this.trackingId;
    }
}

