/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.com.google.common.net.InetAddresses;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hadoop.$internal.org.apache.commons.net.util.SubnetUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.util.StringUtils;

public class MachineList {
    public static final Log LOG = LogFactory.getLog(MachineList.class);
    public static final String WILDCARD_VALUE = "*";
    private final boolean all;
    private final Set<String> ipAddresses;
    private final List<SubnetUtils.SubnetInfo> cidrAddresses;
    private final Set<String> hostNames;
    private final InetAddressFactory addressFactory;

    public MachineList(String hostEntries) {
        this(StringUtils.getTrimmedStringCollection(hostEntries));
    }

    public MachineList(Collection<String> hostEntries) {
        this(hostEntries, InetAddressFactory.S_INSTANCE);
    }

    public MachineList(Collection<String> hostEntries, InetAddressFactory addressFactory) {
        this.addressFactory = addressFactory;
        if (hostEntries != null) {
            if (hostEntries.size() == 1 && hostEntries.contains(WILDCARD_VALUE)) {
                this.all = true;
                this.ipAddresses = null;
                this.hostNames = null;
                this.cidrAddresses = null;
            } else {
                this.all = false;
                HashSet<String> ips = new HashSet<String>();
                LinkedList<SubnetUtils.SubnetInfo> cidrs = new LinkedList<SubnetUtils.SubnetInfo>();
                HashSet<String> hosts = new HashSet<String>();
                for (String hostEntry : hostEntries) {
                    if (hostEntry.indexOf("/") > -1) {
                        try {
                            SubnetUtils subnet = new SubnetUtils(hostEntry);
                            subnet.setInclusiveHostCount(true);
                            cidrs.add(subnet.getInfo());
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            LOG.warn("Invalid CIDR syntax : " + hostEntry);
                            throw e;
                        }
                    }
                    if (InetAddresses.isInetAddress(hostEntry)) {
                        ips.add(hostEntry);
                        continue;
                    }
                    hosts.add(hostEntry);
                }
                this.ipAddresses = ips.size() > 0 ? ips : null;
                this.cidrAddresses = cidrs.size() > 0 ? cidrs : null;
                this.hostNames = hosts.size() > 0 ? hosts : null;
            }
        } else {
            this.all = false;
            this.ipAddresses = null;
            this.hostNames = null;
            this.cidrAddresses = null;
        }
    }

    public boolean includes(String ipAddress) {
        if (this.all) {
            return true;
        }
        if (this.ipAddresses != null && this.ipAddresses.contains(ipAddress)) {
            return true;
        }
        if (this.cidrAddresses != null) {
            for (SubnetUtils.SubnetInfo cidrAddress : this.cidrAddresses) {
                if (!cidrAddress.isInRange(ipAddress)) continue;
                return true;
            }
        }
        if (this.hostNames != null) {
            InetAddress hostAddr;
            try {
                hostAddr = this.addressFactory.getByName(ipAddress);
                if (hostAddr != null && this.hostNames.contains(hostAddr.getCanonicalHostName())) {
                    return true;
                }
            }
            catch (UnknownHostException cidrAddress) {
                // empty catch block
            }
            for (String host : this.hostNames) {
                try {
                    hostAddr = this.addressFactory.getByName(host);
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (!hostAddr.getHostAddress().equals(ipAddress)) continue;
                return true;
            }
        }
        return false;
    }

    @.VisibleForTesting
    public Collection<String> getCollection() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.all) {
            list.add(WILDCARD_VALUE);
        } else {
            if (this.ipAddresses != null) {
                list.addAll(this.ipAddresses);
            }
            if (this.hostNames != null) {
                list.addAll(this.hostNames);
            }
            if (this.cidrAddresses != null) {
                for (SubnetUtils.SubnetInfo cidrAddress : this.cidrAddresses) {
                    list.add(cidrAddress.getCidrSignature());
                }
            }
        }
        return list;
    }

    public static class InetAddressFactory {
        static final InetAddressFactory S_INSTANCE = new InetAddressFactory();

        public InetAddress getByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }
    }
}

