/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.CorsHttpMethods;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.CorsProperties;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.CorsRule;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.DeleteRetentionPolicy;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.LoggingOperations;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.LoggingProperties;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.MetricsLevel;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.MetricsProperties;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.ServiceProperties;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ServicePropertiesHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final ServiceProperties props = new ServiceProperties();
    private CorsRule rule = new CorsRule();
    private boolean retentionPolicyEnabled;
    private int retentionPolicyDays;

    ServicePropertiesHandler() {
    }

    public static ServiceProperties readServicePropertiesFromStream(InputStream stream) throws SAXException, IOException, ParserConfigurationException {
        SAXParser saxParser = Utility.getSAXParser();
        ServicePropertiesHandler handler = new ServicePropertiesHandler();
        handler.props.setLogging(null);
        handler.props.setHourMetrics(null);
        handler.props.setMinuteMetrics(null);
        handler.props.setCors(null);
        handler.props.setDeleteRetentionPolicy(null);
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.props;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("CorsRule".equals(localName)) {
            this.rule = new CorsRule();
        } else if ("Logging".equals(localName)) {
            this.props.setLogging(new LoggingProperties());
        } else if ("HourMetrics".equals(localName)) {
            this.props.setHourMetrics(new MetricsProperties());
        } else if ("MinuteMetrics".equals(localName)) {
            this.props.setMinuteMetrics(new MetricsProperties());
        } else if ("Cors".equals(localName)) {
            this.props.setCors(new CorsProperties());
        } else if ("DeleteRetentionPolicy".equals(localName)) {
            this.props.setDeleteRetentionPolicy(new DeleteRetentionPolicy());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String parentNode = null;
        if (!this.elementStack.isEmpty()) {
            parentNode = this.elementStack.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if (this.retentionPolicyEnabled && "RetentionPolicy".equals(currentNode)) {
            if ("Logging".equals(parentNode)) {
                this.props.getLogging().setRetentionIntervalInDays(this.retentionPolicyDays);
            } else if ("HourMetrics".equals(parentNode)) {
                this.props.getHourMetrics().setRetentionIntervalInDays(this.retentionPolicyDays);
            } else if ("MinuteMetrics".equals(parentNode)) {
                this.props.getMinuteMetrics().setRetentionIntervalInDays(this.retentionPolicyDays);
            }
        } else if ("CorsRule".equals(currentNode)) {
            this.props.getCors().getCorsRules().add(this.rule);
        } else if ("RetentionPolicy".equals(parentNode)) {
            if ("Days".equals(currentNode)) {
                this.retentionPolicyDays = Integer.parseInt(value);
            } else if ("Enabled".equals(currentNode)) {
                this.retentionPolicyEnabled = Boolean.parseBoolean(value);
            }
        } else if ("Logging".equals(parentNode)) {
            if ("Version".equals(currentNode)) {
                this.props.getLogging().setVersion(value);
            } else if ("Delete".equals(currentNode)) {
                if (Boolean.parseBoolean(value)) {
                    this.props.getLogging().getLogOperationTypes().add(LoggingOperations.DELETE);
                }
            } else if ("Read".equals(currentNode)) {
                if (Boolean.parseBoolean(value)) {
                    this.props.getLogging().getLogOperationTypes().add(LoggingOperations.READ);
                }
            } else if ("Write".equals(currentNode) && Boolean.parseBoolean(value)) {
                this.props.getLogging().getLogOperationTypes().add(LoggingOperations.WRITE);
            }
        } else if ("HourMetrics".equals(parentNode)) {
            MetricsProperties metrics = this.props.getHourMetrics();
            if ("Version".equals(currentNode)) {
                metrics.setVersion(value);
            } else if ("Enabled".equals(currentNode)) {
                if (Boolean.parseBoolean(value)) {
                    metrics.setMetricsLevel(metrics.getMetricsLevel() != MetricsLevel.SERVICE_AND_API ? MetricsLevel.SERVICE : MetricsLevel.SERVICE_AND_API);
                }
            } else if ("IncludeAPIs".equals(currentNode) && Boolean.parseBoolean(value) && metrics.getMetricsLevel() != MetricsLevel.DISABLED) {
                metrics.setMetricsLevel(MetricsLevel.SERVICE_AND_API);
            }
        } else if ("MinuteMetrics".equals(parentNode)) {
            MetricsProperties metrics = this.props.getMinuteMetrics();
            if ("Version".equals(currentNode)) {
                metrics.setVersion(value);
            } else if ("Enabled".equals(currentNode)) {
                if (Boolean.parseBoolean(value)) {
                    metrics.setMetricsLevel(metrics.getMetricsLevel() != MetricsLevel.SERVICE_AND_API ? MetricsLevel.SERVICE : MetricsLevel.SERVICE_AND_API);
                }
            } else if ("IncludeAPIs".equals(currentNode) && Boolean.parseBoolean(value) && metrics.getMetricsLevel() != MetricsLevel.DISABLED) {
                metrics.setMetricsLevel(MetricsLevel.SERVICE_AND_API);
            }
        } else if ("DefaultServiceVersion".equals(currentNode)) {
            this.props.setDefaultServiceVersion(value);
        } else if ("CorsRule".equals(parentNode)) {
            if ("AllowedOrigins".equals(currentNode)) {
                if (value != null) {
                    this.rule.setAllowedOrigins(ServicePropertiesHandler.splitToList(value, ","));
                }
            } else if ("AllowedMethods".equals(currentNode)) {
                if (value != null) {
                    this.rule.setAllowedMethods(ServicePropertiesHandler.splitToEnumSet(value, ","));
                }
            } else if ("ExposedHeaders".equals(currentNode)) {
                if (value != null) {
                    this.rule.setExposedHeaders(ServicePropertiesHandler.splitToList(value, ","));
                }
            } else if ("AllowedHeaders".equals(currentNode)) {
                if (value != null) {
                    this.rule.setAllowedHeaders(ServicePropertiesHandler.splitToList(value, ","));
                }
            } else if ("MaxAgeInSeconds".equals(currentNode)) {
                this.rule.setMaxAgeInSeconds(Integer.parseInt(value));
            }
        } else if ("DeleteRetentionPolicy".equals(parentNode)) {
            if ("Enabled".equals(currentNode)) {
                if (value != null) {
                    boolean enabled = Boolean.parseBoolean(value);
                    if (enabled) {
                        this.props.getDeleteRetentionPolicy().setEnabled(true);
                    } else {
                        this.props.getDeleteRetentionPolicy().setEnabled(false);
                    }
                }
            } else if ("Days".equals(currentNode) && value != null) {
                this.props.getDeleteRetentionPolicy().setRetentionIntervalInDays(Integer.parseInt(value));
            }
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }

    private static List<String> splitToList(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list;
    }

    private static EnumSet<CorsHttpMethods> splitToEnumSet(String str, String delimiter) {
        EnumSet<CorsHttpMethods> set = EnumSet.noneOf(CorsHttpMethods.class);
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            set.add(CorsHttpMethods.valueOf(st.nextToken()));
        }
        return set;
    }
}

