/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.PageRangeDiff;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class PageRangeDiffHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final List<PageRangeDiff> pages = new ArrayList<PageRangeDiff>();
    private long startOffset;
    private long endOffset;

    PageRangeDiffHandler() {
    }

    protected static List<PageRangeDiff> getPageRangesDiff(InputStream streamRef) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        PageRangeDiffHandler handler = new PageRangeDiffHandler();
        saxParser.parse(streamRef, (DefaultHandler)handler);
        return handler.pages;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String value = this.bld.toString();
        if (value.isEmpty()) {
            value = null;
        }
        if ("ClearRange".equals(currentNode)) {
            PageRangeDiff pageRef = new PageRangeDiff(this.startOffset, this.endOffset, true);
            this.pages.add(pageRef);
        } else if ("PageRange".equals(currentNode)) {
            PageRangeDiff pageRef = new PageRangeDiff(this.startOffset, this.endOffset, false);
            this.pages.add(pageRef);
        } else if ("Start".equals(currentNode)) {
            this.startOffset = Long.parseLong(value);
        } else if ("End".equals(currentNode)) {
            this.endOffset = Long.parseLong(value);
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }
}

