/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.UniversalTag;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Simple;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class Asn1ObjectIdentifier
extends Asn1Simple<String> {
    public Asn1ObjectIdentifier() {
        this((String)null);
    }

    public Asn1ObjectIdentifier(String value) {
        super(UniversalTag.OBJECT_IDENTIFIER, value);
    }

    @Override
    protected void toBytes() {
        byte[][] bytesArr = this.convert((String)this.getValue());
        int allLen = 0;
        for (byte[] bytes : bytesArr) {
            allLen += bytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(allLen);
        for (byte[] bytes : bytesArr) {
            buffer.put(bytes);
        }
        this.setBytes(buffer.array());
    }

    @Override
    protected void toValue() {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = this.getBytes();
        byte[][] bytesGroups = this.group(bytes);
        BigInteger[] coms = this.convert(bytesGroups);
        long first = coms[0].longValue();
        sb.append(first / 40L).append('.');
        sb.append(first % 40L);
        if (coms.length > 1) {
            sb.append('.');
        }
        for (int i = 1; i < coms.length; ++i) {
            sb.append(coms[i].toString());
            if (i == coms.length - 1) continue;
            sb.append('.');
        }
        String value = sb.toString();
        this.setValue(value);
    }

    private BigInteger[] convert(byte[][] bytesGroups) {
        BigInteger[] comps = new BigInteger[bytesGroups.length];
        for (int i = 0; i < bytesGroups.length; ++i) {
            comps[i] = this.convert(bytesGroups[i]);
        }
        return comps;
    }

    private BigInteger convert(byte[] bytes) {
        BigInteger value = BigInteger.valueOf(bytes[0] & 0x7F);
        for (int i = 1; i < bytes.length; ++i) {
            value = value.shiftLeft(7);
            value = value.or(BigInteger.valueOf(bytes[i] & 0x7F));
        }
        return value;
    }

    private byte[][] group(byte[] bytes) {
        int i;
        int count = 0;
        int[] countArr = new int[bytes.length];
        for (i = 0; i < countArr.length; ++i) {
            countArr[i] = 0;
        }
        int j = 0;
        for (i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0x80) != 0) {
                int n = j;
                countArr[n] = countArr[n] + 1;
                continue;
            }
            int n = j++;
            countArr[n] = countArr[n] + 1;
        }
        count = j;
        byte[][] bytesGroups = new byte[count][];
        for (i = 0; i < count; ++i) {
            bytesGroups[i] = new byte[countArr[i]];
        }
        int k = 0;
        j = 0;
        for (i = 0; i < bytes.length; ++i) {
            bytesGroups[j][k++] = bytes[i];
            if ((bytes[i] & 0x80) != 0) continue;
            ++j;
            k = 0;
        }
        return bytesGroups;
    }

    private byte[][] convert(String oid) {
        String[] parts = oid.split("\\.");
        BigInteger[] coms = new BigInteger[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            coms[i - 1] = new BigInteger(parts[i]);
        }
        coms[0] = coms[0].add(BigInteger.valueOf(Integer.parseInt(parts[0]) * 40));
        byte[][] bytesGroups = new byte[coms.length][];
        for (int i = 0; i < coms.length; ++i) {
            bytesGroups[i] = this.convert(coms[i]);
        }
        return bytesGroups;
    }

    private byte[] convert(BigInteger value) {
        int bitLen = value.bitLength();
        if (bitLen < 8) {
            return new byte[]{value.byteValue()};
        }
        int len = (bitLen + 6) / 7;
        byte[] bytes = new byte[len];
        BigInteger tmpValue = value;
        for (int i = len - 1; i >= 0; --i) {
            bytes[i] = (byte)(tmpValue.byteValue() & 0x7F | 0x80);
            tmpValue = tmpValue.shiftRight(7);
        }
        int n = len - 1;
        bytes[n] = (byte)(bytes[n] & 0x7F);
        return bytes;
    }
}

