/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.asn1.util;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.util.Utf8;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class IOUtil {
    private IOUtil() {
    }

    public static byte[] readInputStream(InputStream in) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = in.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            in.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static void readInputStream(InputStream in, byte[] buf) throws IOException {
        int toRead = buf.length;
        int off = 0;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Bad inputStream, premature EOF");
            }
            toRead -= ret;
            off += ret;
        }
        in.close();
    }

    public static String readInput(InputStream in) throws IOException {
        byte[] content = IOUtil.readInputStream(in);
        return Utf8.toString(content);
    }

    public static String readFile(File file) throws IOException {
        long len = 0L;
        if (file.length() >= Integer.MAX_VALUE) {
            throw new IOException("Too large file, unexpected!");
        }
        len = file.length();
        byte[] buf = new byte[(int)len];
        InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
        IOUtil.readInputStream(is, buf);
        return Utf8.toString(buf);
    }

    public static void writeFile(String content, File file) throws IOException {
        OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        WritableByteChannel channel = Channels.newChannel(outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(Utf8.toBytes(content));
        channel.write(buffer);
        outputStream.close();
    }
}

