/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.security;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.util.JsonSerialization;

public final class JsonUtils {
    public static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);

    private JsonUtils() {
    }

    public static Map<?, ?> parse(String jsonString) throws IOException {
        try {
            return (Map)JsonSerialization.mapReader().readValue(jsonString);
        }
        catch (Exception e) {
            LOG.debug("JSON Parsing exception: {} while parsing {}", (Object)e.getMessage(), (Object)jsonString);
            if (jsonString.toLowerCase(Locale.ENGLISH).contains("server error")) {
                LOG.error("Internal Server Error was encountered while making a request");
            }
            throw new IOException("JSON Parsing Error: " + e.getMessage(), e);
        }
    }
}

