/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import io.prestosql.hadoop.$internal.org.codehaus.jackson.JsonFactory;
import io.prestosql.hadoop.$internal.org.codehaus.jackson.JsonParser;
import io.prestosql.hadoop.$internal.org.codehaus.jackson.JsonToken;
import io.prestosql.hadoop.$internal.org.codehaus.jackson.map.ObjectMapper;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.utils.SSLSocketFactoryEx;

public class AbfsHttpOperation {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsHttpOperation.class);
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;
    private static final int CLEAN_UP_BUFFER_SIZE = 65536;
    private static final int ONE_THOUSAND = 1000;
    private static final int ONE_MILLION = 1000000;
    private final String method;
    private final URL url;
    private HttpURLConnection connection;
    private int statusCode;
    private String statusDescription;
    private String storageErrorCode = "";
    private String storageErrorMessage = "";
    private String clientRequestId = "";
    private String requestId = "";
    private ListResultSchema listResultSchema = null;
    private int bytesSent;
    private long bytesReceived;
    private final boolean isTraceEnabled = LOG.isTraceEnabled();
    private long connectionTimeMs;
    private long sendRequestTimeMs;
    private long recvResponseTimeMs;

    protected HttpURLConnection getConnection() {
        return this.connection;
    }

    public String getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public String getStorageErrorCode() {
        return this.storageErrorCode;
    }

    public String getStorageErrorMessage() {
        return this.storageErrorMessage;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public int getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public ListResultSchema getListResultSchema() {
        return this.listResultSchema;
    }

    public String getResponseHeader(String httpHeader) {
        return this.connection.getHeaderField(httpHeader);
    }

    public String toString() {
        String urlStr = this.url.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(this.statusCode);
        sb.append(",");
        sb.append(this.storageErrorCode);
        sb.append(",cid=");
        sb.append(this.clientRequestId);
        sb.append(",rid=");
        sb.append(this.requestId);
        if (this.isTraceEnabled) {
            sb.append(",connMs=");
            sb.append(this.connectionTimeMs);
            sb.append(",sendMs=");
            sb.append(this.sendRequestTimeMs);
            sb.append(",recvMs=");
            sb.append(this.recvResponseTimeMs);
        }
        sb.append(",sent=");
        sb.append(this.bytesSent);
        sb.append(",recv=");
        sb.append(this.bytesReceived);
        sb.append(",");
        sb.append(this.method);
        sb.append(",");
        sb.append(urlStr);
        return sb.toString();
    }

    public AbfsHttpOperation(URL url, String method, List<AbfsHttpHeader> requestHeaders) throws IOException {
        this.url = url;
        this.method = method;
        this.clientRequestId = UUID.randomUUID().toString();
        this.connection = this.openConnection();
        if (this.connection instanceof HttpsURLConnection) {
            HttpsURLConnection secureConn = (HttpsURLConnection)this.connection;
            SSLSocketFactoryEx sslSocketFactory = SSLSocketFactoryEx.getDefaultFactory();
            if (sslSocketFactory != null) {
                secureConn.setSSLSocketFactory(sslSocketFactory);
            }
        }
        this.connection.setConnectTimeout(30000);
        this.connection.setReadTimeout(30000);
        this.connection.setRequestMethod(method);
        for (AbfsHttpHeader header : requestHeaders) {
            this.connection.setRequestProperty(header.getName(), header.getValue());
        }
        this.connection.setRequestProperty("x-ms-client-request-id", this.clientRequestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(byte[] buffer, int offset, int length) throws IOException {
        this.connection.setDoOutput(true);
        this.connection.setFixedLengthStreamingMode(length);
        if (buffer == null) {
            buffer = new byte[]{};
            offset = 0;
            length = 0;
        }
        long startTime = 0L;
        if (this.isTraceEnabled) {
            startTime = System.nanoTime();
        }
        try (OutputStream outputStream = this.connection.getOutputStream();){
            this.bytesSent = length;
            outputStream.write(buffer, offset, length);
        }
        finally {
            if (this.isTraceEnabled) {
                this.sendRequestTimeMs = this.elapsedTimeMs(startTime);
            }
        }
    }

    public void processResponse(byte[] buffer, int offset, int length) throws IOException {
        long startTime = 0L;
        if (this.isTraceEnabled) {
            startTime = System.nanoTime();
        }
        this.statusCode = this.connection.getResponseCode();
        if (this.isTraceEnabled) {
            this.recvResponseTimeMs = this.elapsedTimeMs(startTime);
        }
        this.statusDescription = this.connection.getResponseMessage();
        this.requestId = this.connection.getHeaderField("x-ms-request-id");
        if (this.requestId == null) {
            this.requestId = "";
        }
        if ("HEAD".equals(this.method)) {
            return;
        }
        if (this.isTraceEnabled) {
            startTime = System.nanoTime();
        }
        if (this.statusCode >= 400) {
            this.processStorageErrorResponse();
            if (this.isTraceEnabled) {
                this.recvResponseTimeMs += this.elapsedTimeMs(startTime);
            }
            this.bytesReceived = this.connection.getHeaderFieldLong("Content-Length", 0L);
        } else {
            int totalBytesRead;
            try (InputStream stream = this.connection.getInputStream();){
                if (this.isNullInputStream(stream)) {
                    return;
                }
                boolean endOfStream = false;
                if ("GET".equals(this.method) && buffer == null) {
                    this.parseListFilesResponse(stream);
                } else {
                    int bytesRead;
                    if (buffer != null) {
                        for (totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
                            bytesRead = stream.read(buffer, offset + totalBytesRead, length - totalBytesRead);
                            if (bytesRead != -1) continue;
                            endOfStream = true;
                            break;
                        }
                    }
                    if (!endOfStream && stream.read() != -1) {
                        bytesRead = 0;
                        byte[] b = new byte[65536];
                        while ((bytesRead = stream.read(b)) >= 0) {
                            totalBytesRead += bytesRead;
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("UnexpectedError: ", ex);
                throw ex;
            }
            finally {
                if (this.isTraceEnabled) {
                    this.recvResponseTimeMs += this.elapsedTimeMs(startTime);
                }
                this.bytesReceived = totalBytesRead;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection openConnection() throws IOException {
        if (!this.isTraceEnabled) {
            return (HttpURLConnection)this.url.openConnection();
        }
        long start = System.nanoTime();
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
            return httpURLConnection;
        }
        finally {
            this.connectionTimeMs = this.elapsedTimeMs(start);
        }
    }

    private void processStorageErrorResponse() {
        try (InputStream stream = this.connection.getErrorStream();){
            if (stream == null) {
                return;
            }
            JsonFactory jf = new JsonFactory();
            try (JsonParser jp = jf.createJsonParser(stream);){
                jp.nextToken();
                jp.nextToken();
                jp.nextToken();
                jp.nextToken();
                while (jp.hasCurrentToken()) {
                    if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                        String fieldName = jp.getCurrentName();
                        jp.nextToken();
                        String fieldValue = jp.getText();
                        switch (fieldName) {
                            case "code": {
                                this.storageErrorCode = fieldValue;
                                break;
                            }
                            case "message": {
                                this.storageErrorMessage = fieldValue;
                                break;
                            }
                        }
                    }
                    jp.nextToken();
                }
            }
        }
        catch (IOException ex) {
            LOG.debug("ExpectedError: ", ex);
        }
    }

    private long elapsedTimeMs(long startTime) {
        return (System.nanoTime() - startTime) / 1000000L;
    }

    private void parseListFilesResponse(InputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        if (this.listResultSchema != null) {
            return;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.listResultSchema = objectMapper.readValue(stream, ListResultSchema.class);
        }
        catch (IOException ex) {
            LOG.error("Unable to deserialize list results", ex);
            throw ex;
        }
    }

    private boolean isNullInputStream(InputStream stream) {
        return stream == null;
    }
}

