/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.KeyProviderException;
import org.apache.hadoop.fs.azurebfs.services.SimpleKeyProvider;
import org.apache.hadoop.util.Shell;

public class ShellDecryptionKeyProvider
extends SimpleKeyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ShellDecryptionKeyProvider.class);

    @Override
    public String getStorageAccountKey(String accountName, Configuration rawConfig) throws KeyProviderException {
        AbfsConfiguration abfsConfig;
        String envelope = super.getStorageAccountKey(accountName, rawConfig);
        try {
            abfsConfig = new AbfsConfiguration(rawConfig, accountName);
        }
        catch (IOException | IllegalAccessException e) {
            throw new KeyProviderException("Unable to get key from credential providers.", (Throwable)e);
        }
        String command = abfsConfig.get("fs.azure.shellkeyprovider.script");
        if (command == null) {
            throw new KeyProviderException("Script path is not specified via fs.azure.shellkeyprovider.script");
        }
        String[] cmd = command.split(" ");
        String[] cmdWithEnvelope = Arrays.copyOf(cmd, cmd.length + 1);
        cmdWithEnvelope[cmdWithEnvelope.length - 1] = envelope;
        String decryptedKey = null;
        try {
            decryptedKey = Shell.execCommand(cmdWithEnvelope);
        }
        catch (IOException ex) {
            throw new KeyProviderException(ex);
        }
        return decryptedKey.trim();
    }
}

