/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;

abstract class AbstractINodeDiff<N extends INode, A extends INodeAttributes, D extends AbstractINodeDiff<N, A, D>>
implements Comparable<Integer> {
    private int snapshotId;
    A snapshotINode;
    private D posteriorDiff;

    AbstractINodeDiff(int snapshotId, A snapshotINode, D posteriorDiff) {
        this.snapshotId = snapshotId;
        this.snapshotINode = snapshotINode;
        this.posteriorDiff = posteriorDiff;
    }

    @Override
    public final int compareTo(Integer that) {
        return Snapshot.ID_INTEGER_COMPARATOR.compare(this.snapshotId, that);
    }

    public final int getSnapshotId() {
        return this.snapshotId;
    }

    final void setSnapshotId(int snapshot) {
        this.snapshotId = snapshot;
    }

    final D getPosterior() {
        return this.posteriorDiff;
    }

    final void setPosterior(D posterior) {
        this.posteriorDiff = posterior;
    }

    void saveSnapshotCopy(A snapshotCopy) {
        Preconditions.checkState(this.snapshotINode == null, "Expected snapshotINode to be null");
        this.snapshotINode = snapshotCopy;
    }

    A getSnapshotINode() {
        AbstractINodeDiff<N, A, D> d = this;
        while (d.snapshotINode == null) {
            if (d.posteriorDiff == null) {
                return null;
            }
            d = d.posteriorDiff;
        }
        return d.snapshotINode;
    }

    abstract void combinePosteriorAndCollectBlocks(INode.ReclaimContext var1, N var2, D var3);

    abstract void destroyDiffAndCollectBlocks(INode.ReclaimContext var1, N var2);

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getSnapshotId() + " (post=" + (this.posteriorDiff == null ? null : Integer.valueOf(((AbstractINodeDiff)this.posteriorDiff).getSnapshotId())) + ")";
    }

    void writeSnapshot(DataOutput out) throws IOException {
        out.writeInt(this.snapshotId);
    }

    abstract void write(DataOutput var1, SnapshotFSImageFormat.ReferenceMap var2) throws IOException;
}

