/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.PriorityQueue;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Merger {
    private static final Logger LOG = LoggerFactory.getLogger(Merger.class);
    private static LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapreduce.cluster.local.dir");

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, Path[] inputs, boolean deleteInputs, int mergeFactor, Path tmpDir, RawComparator<K> comparator, Progressable reporter, Counters.Counter readsCounter, Counters.Counter writesCounter, Progress mergePhase) throws IOException {
        return new MergeQueue<K, V>(conf, fs, inputs, deleteInputs, codec, comparator, reporter, null, TaskType.REDUCE).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, mergePhase);
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, Path[] inputs, boolean deleteInputs, int mergeFactor, Path tmpDir, RawComparator<K> comparator, Progressable reporter, Counters.Counter readsCounter, Counters.Counter writesCounter, Counters.Counter mergedMapOutputsCounter, Progress mergePhase) throws IOException {
        return new MergeQueue<K, V>(conf, fs, inputs, deleteInputs, codec, comparator, reporter, mergedMapOutputsCounter, TaskType.REDUCE).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, mergePhase);
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, List<Segment<K, V>> segments, int mergeFactor, Path tmpDir, RawComparator<K> comparator, Progressable reporter, Counters.Counter readsCounter, Counters.Counter writesCounter, Progress mergePhase) throws IOException {
        return Merger.merge(conf, fs, keyClass, valueClass, segments, mergeFactor, tmpDir, comparator, reporter, false, readsCounter, writesCounter, mergePhase);
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, List<Segment<K, V>> segments, int mergeFactor, Path tmpDir, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, Counters.Counter readsCounter, Counters.Counter writesCounter, Progress mergePhase) throws IOException {
        return new MergeQueue<K, V>(conf, fs, segments, comparator, reporter, sortSegments, TaskType.REDUCE).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, mergePhase);
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, List<Segment<K, V>> segments, int mergeFactor, Path tmpDir, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, Counters.Counter readsCounter, Counters.Counter writesCounter, Progress mergePhase, TaskType taskType) throws IOException {
        return new MergeQueue<K, V>(conf, fs, segments, comparator, reporter, sortSegments, codec, taskType).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, mergePhase);
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, List<Segment<K, V>> segments, int mergeFactor, int inMemSegments, Path tmpDir, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, Counters.Counter readsCounter, Counters.Counter writesCounter, Progress mergePhase) throws IOException {
        return new MergeQueue<K, V>(conf, fs, segments, comparator, reporter, sortSegments, TaskType.REDUCE).merge(keyClass, valueClass, mergeFactor, inMemSegments, tmpDir, readsCounter, writesCounter, mergePhase);
    }

    public static <K, V> RawKeyValueIterator merge(Configuration conf, FileSystem fs, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, List<Segment<K, V>> segments, int mergeFactor, int inMemSegments, Path tmpDir, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, Counters.Counter readsCounter, Counters.Counter writesCounter, Progress mergePhase) throws IOException {
        return new MergeQueue<K, V>(conf, fs, segments, comparator, reporter, sortSegments, codec, TaskType.REDUCE).merge(keyClass, valueClass, mergeFactor, inMemSegments, tmpDir, readsCounter, writesCounter, mergePhase);
    }

    public static <K, V> void writeFile(RawKeyValueIterator records, IFile.Writer<K, V> writer, Progressable progressable, Configuration conf) throws IOException {
        long progressBar = conf.getLong("mapreduce.task.merge.progress.records", 10000L);
        long recordCtr = 0L;
        while (records.next()) {
            writer.append(records.getKey(), records.getValue());
            if (recordCtr++ % progressBar != 0L) continue;
            progressable.progress();
        }
    }

    private static class MergeQueue<K, V>
    extends PriorityQueue<Segment<K, V>>
    implements RawKeyValueIterator {
        Configuration conf;
        FileSystem fs;
        CompressionCodec codec;
        List<Segment<K, V>> segments = new ArrayList<Segment<K, V>>();
        RawComparator<K> comparator;
        private long totalBytesProcessed;
        private float progPerByte;
        private Progress mergeProgress = new Progress();
        Progressable reporter;
        DataInputBuffer key;
        final DataInputBuffer value = new DataInputBuffer();
        final DataInputBuffer diskIFileValue = new DataInputBuffer();
        private boolean includeFinalMerge = false;
        Segment<K, V> minSegment;
        Comparator<Segment<K, V>> segmentComparator = new Comparator<Segment<K, V>>(this){
            final /* synthetic */ MergeQueue this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(Segment<K, V> o1, Segment<K, V> o2) {
                if (o1.getLength() == o2.getLength()) {
                    return 0;
                }
                return o1.getLength() < o2.getLength() ? -1 : 1;
            }
        };

        private void considerFinalMergeForProgress() {
            this.includeFinalMerge = true;
        }

        public MergeQueue(Configuration conf, FileSystem fs, Path[] inputs, boolean deleteInputs, CompressionCodec codec, RawComparator<K> comparator, Progressable reporter) throws IOException {
            this(conf, fs, inputs, deleteInputs, codec, comparator, reporter, null, TaskType.REDUCE);
        }

        public MergeQueue(Configuration conf, FileSystem fs, Path[] inputs, boolean deleteInputs, CompressionCodec codec, RawComparator<K> comparator, Progressable reporter, Counters.Counter mergedMapOutputsCounter, TaskType taskType) throws IOException {
            this.conf = conf;
            this.fs = fs;
            this.codec = codec;
            this.comparator = comparator;
            this.reporter = reporter;
            if (taskType == TaskType.MAP) {
                this.considerFinalMergeForProgress();
            }
            for (Path file : inputs) {
                LOG.debug("MergeQ: adding: " + file);
                this.segments.add(new Segment(conf, fs, file, codec, !deleteInputs, file.toString().endsWith(Task.MERGED_OUTPUT_PREFIX) ? null : mergedMapOutputsCounter));
            }
            Collections.sort(this.segments, this.segmentComparator);
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment<K, V>> segments, RawComparator<K> comparator, Progressable reporter) {
            this(conf, fs, segments, comparator, reporter, false, TaskType.REDUCE);
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment<K, V>> segments, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, TaskType taskType) {
            this.conf = conf;
            this.fs = fs;
            this.comparator = comparator;
            this.segments = segments;
            this.reporter = reporter;
            if (taskType == TaskType.MAP) {
                this.considerFinalMergeForProgress();
            }
            if (sortSegments) {
                Collections.sort(segments, this.segmentComparator);
            }
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment<K, V>> segments, RawComparator<K> comparator, Progressable reporter, boolean sortSegments, CompressionCodec codec, TaskType taskType) {
            this(conf, fs, segments, comparator, reporter, sortSegments, taskType);
            this.codec = codec;
        }

        @Override
        public void close() throws IOException {
            Segment segment;
            while ((segment = (Segment)this.pop()) != null) {
                segment.close();
            }
        }

        @Override
        public DataInputBuffer getKey() throws IOException {
            return this.key;
        }

        @Override
        public DataInputBuffer getValue() throws IOException {
            return this.value;
        }

        private void adjustPriorityQueue(Segment<K, V> reader) throws IOException {
            long startPos = reader.getReader().bytesRead;
            boolean hasNext = reader.nextRawKey();
            long endPos = reader.getReader().bytesRead;
            this.totalBytesProcessed += endPos - startPos;
            this.mergeProgress.set(Math.min(1.0f, (float)this.totalBytesProcessed * this.progPerByte));
            if (hasNext) {
                this.adjustTop();
            } else {
                this.pop();
                reader.close();
            }
        }

        private void resetKeyValue() {
            this.key = null;
            this.value.reset(new byte[0], 0);
            this.diskIFileValue.reset(new byte[0], 0);
        }

        @Override
        public boolean next() throws IOException {
            if (this.size() == 0) {
                this.resetKeyValue();
                return false;
            }
            if (this.minSegment != null) {
                this.adjustPriorityQueue(this.minSegment);
                if (this.size() == 0) {
                    this.minSegment = null;
                    this.resetKeyValue();
                    return false;
                }
            }
            this.minSegment = (Segment)this.top();
            long startPos = this.minSegment.getReader().bytesRead;
            this.key = this.minSegment.getKey();
            if (!this.minSegment.inMemory()) {
                this.minSegment.getValue(this.diskIFileValue);
                this.value.reset(this.diskIFileValue.getData(), this.diskIFileValue.getLength());
            } else {
                this.minSegment.getValue(this.value);
            }
            long endPos = this.minSegment.getReader().bytesRead;
            this.totalBytesProcessed += endPos - startPos;
            this.mergeProgress.set(Math.min(1.0f, (float)this.totalBytesProcessed * this.progPerByte));
            return true;
        }

        @Override
        protected boolean lessThan(Object a, Object b) {
            DataInputBuffer key1 = ((Segment)a).getKey();
            DataInputBuffer key2 = ((Segment)b).getKey();
            int s1 = key1.getPosition();
            int l1 = key1.getLength() - s1;
            int s2 = key2.getPosition();
            int l2 = key2.getLength() - s2;
            return this.comparator.compare(key1.getData(), s1, l1, key2.getData(), s2, l2) < 0;
        }

        public RawKeyValueIterator merge(Class<K> keyClass, Class<V> valueClass, int factor, Path tmpDir, Counters.Counter readsCounter, Counters.Counter writesCounter, Progress mergePhase) throws IOException {
            return this.merge(keyClass, valueClass, factor, 0, tmpDir, readsCounter, writesCounter, mergePhase);
        }

        RawKeyValueIterator merge(Class<K> keyClass, Class<V> valueClass, int factor, int inMem, Path tmpDir, Counters.Counter readsCounter, Counters.Counter writesCounter, Progress mergePhase) throws IOException {
            long totalBytes;
            LOG.info("Merging " + this.segments.size() + " sorted segments");
            int numSegments = this.segments.size();
            int origFactor = factor;
            int passNo = 1;
            if (mergePhase != null) {
                this.mergeProgress = mergePhase;
            }
            if ((totalBytes = this.computeBytesInMerges(factor, inMem)) != 0L) {
                this.progPerByte = 1.0f / (float)totalBytes;
            }
            while (true) {
                factor = this.getPassFactor(factor, passNo, numSegments - inMem);
                if (1 == passNo) {
                    factor += inMem;
                }
                ArrayList<Segment<K, V>> segmentsToMerge = new ArrayList<Segment<K, V>>();
                int segmentsConsidered = 0;
                int numSegmentsToConsider = factor;
                long startBytes = 0L;
                while (true) {
                    List<Segment<K, V>> mStream = this.getSegmentDescriptors(numSegmentsToConsider);
                    Iterator<Segment<K, V>> iterator = mStream.iterator();
                    while (iterator.hasNext()) {
                        Segment<K, V> segment = iterator.next();
                        segment.init(readsCounter);
                        long startPos = segment.getReader().bytesRead;
                        boolean bl = segment.nextRawKey();
                        long endPos = segment.getReader().bytesRead;
                        if (bl) {
                            startBytes += endPos - startPos;
                            segmentsToMerge.add(segment);
                            ++segmentsConsidered;
                            continue;
                        }
                        segment.close();
                        --numSegments;
                    }
                    if (segmentsConsidered == factor || this.segments.size() == 0) break;
                    numSegmentsToConsider = factor - segmentsConsidered;
                }
                this.initialize(segmentsToMerge.size());
                this.clear();
                for (Segment segment : segmentsToMerge) {
                    this.put(segment);
                }
                if (numSegments <= factor) {
                    if (!this.includeFinalMerge) {
                        this.totalBytesProcessed = 0L;
                        totalBytes = 0L;
                        for (int i = 0; i < segmentsToMerge.size(); ++i) {
                            totalBytes += ((Segment)segmentsToMerge.get(i)).getRawDataLength();
                        }
                    }
                    if (totalBytes != 0L) {
                        this.progPerByte = 1.0f / (float)totalBytes;
                    }
                    this.totalBytesProcessed += startBytes;
                    if (totalBytes != 0L) {
                        this.mergeProgress.set(Math.min(1.0f, (float)this.totalBytesProcessed * this.progPerByte));
                    } else {
                        this.mergeProgress.set(1.0f);
                    }
                    LOG.info("Down to the last merge-pass, with " + numSegments + " segments left of total size: " + (totalBytes - this.totalBytesProcessed) + " bytes");
                    return this;
                }
                LOG.info("Merging " + segmentsToMerge.size() + " intermediate segments out of a total of " + (this.segments.size() + segmentsToMerge.size()));
                long bytesProcessedInPrevMerges = this.totalBytesProcessed;
                this.totalBytesProcessed += startBytes;
                long approxOutputSize = 0L;
                for (Segment segment : segmentsToMerge) {
                    approxOutputSize = (long)((double)approxOutputSize + ((double)segment.getLength() + ChecksumFileSystem.getApproxChkSumLength(segment.getLength())));
                }
                Path tmpFilename = new Path(tmpDir, "intermediate").suffix("." + passNo);
                Path path = lDirAlloc.getLocalPathForWrite(tmpFilename.toString(), approxOutputSize, this.conf);
                FSDataOutputStream out = this.fs.create(path);
                out = CryptoUtils.wrapIfNecessary(this.conf, out);
                IFile.Writer<K, V> writer = new IFile.Writer<K, V>(this.conf, out, keyClass, valueClass, this.codec, writesCounter, true);
                Merger.writeFile(this, writer, this.reporter, this.conf);
                writer.close();
                this.close();
                Segment tempSegment = new Segment(this.conf, this.fs, path, this.codec, false);
                int pos = Collections.binarySearch(this.segments, tempSegment, this.segmentComparator);
                if (pos < 0) {
                    pos = -pos - 1;
                }
                this.segments.add(pos, tempSegment);
                numSegments = this.segments.size();
                long inputBytesOfThisMerge = this.totalBytesProcessed - bytesProcessedInPrevMerges;
                if ((totalBytes -= inputBytesOfThisMerge - tempSegment.getRawDataLength()) != 0L) {
                    this.progPerByte = 1.0f / (float)totalBytes;
                }
                ++passNo;
                factor = origFactor;
            }
        }

        private int getPassFactor(int factor, int passNo, int numSegments) {
            if (passNo > 1 || numSegments <= factor || factor == 1) {
                return factor;
            }
            int mod = (numSegments - 1) % (factor - 1);
            if (mod == 0) {
                return factor;
            }
            return mod + 1;
        }

        private List<Segment<K, V>> getSegmentDescriptors(int numDescriptors) {
            if (numDescriptors > this.segments.size()) {
                ArrayList<Segment<K, V>> subList = new ArrayList<Segment<K, V>>(this.segments);
                this.segments.clear();
                return subList;
            }
            ArrayList<Segment<K, V>> subList = new ArrayList<Segment<K, V>>(this.segments.subList(0, numDescriptors));
            for (int i = 0; i < numDescriptors; ++i) {
                this.segments.remove(0);
            }
            return subList;
        }

        long computeBytesInMerges(int factor, int inMem) {
            int numSegments = this.segments.size();
            ArrayList<Long> segmentSizes = new ArrayList<Long>(numSegments);
            long totalBytes = 0L;
            int n = numSegments - inMem;
            int f = this.getPassFactor(factor, 1, n) + inMem;
            n = numSegments;
            for (int i = 0; i < numSegments; ++i) {
                segmentSizes.add(this.segments.get(i).getRawDataLength());
            }
            boolean considerFinalMerge = this.includeFinalMerge;
            while (n > f || considerFinalMerge) {
                if (n <= f) {
                    considerFinalMerge = false;
                }
                long mergedSize = 0L;
                f = Math.min(f, segmentSizes.size());
                for (int j = 0; j < f; ++j) {
                    mergedSize += ((Long)segmentSizes.remove(0)).longValue();
                }
                totalBytes += mergedSize;
                int pos = Collections.binarySearch(segmentSizes, mergedSize);
                if (pos < 0) {
                    pos = -pos - 1;
                }
                segmentSizes.add(pos, mergedSize);
                n -= f - 1;
                f = factor;
            }
            return totalBytes;
        }

        @Override
        public Progress getProgress() {
            return this.mergeProgress;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Segment<K, V> {
        IFile.Reader<K, V> reader = null;
        final DataInputBuffer key = new DataInputBuffer();
        Configuration conf = null;
        FileSystem fs = null;
        Path file = null;
        boolean preserve = false;
        CompressionCodec codec = null;
        long segmentOffset = 0L;
        long segmentLength = -1L;
        long rawDataLength = -1L;
        Counters.Counter mapOutputsCounter = null;

        public Segment(Configuration conf, FileSystem fs, Path file, CompressionCodec codec, boolean preserve) throws IOException {
            this(conf, fs, file, codec, preserve, null);
        }

        public Segment(Configuration conf, FileSystem fs, Path file, CompressionCodec codec, boolean preserve, Counters.Counter mergedMapOutputsCounter) throws IOException {
            this(conf, fs, file, 0L, fs.getFileStatus(file).getLen(), codec, preserve, mergedMapOutputsCounter);
        }

        public Segment(Configuration conf, FileSystem fs, Path file, CompressionCodec codec, boolean preserve, Counters.Counter mergedMapOutputsCounter, long rawDataLength) throws IOException {
            this(conf, fs, file, 0L, fs.getFileStatus(file).getLen(), codec, preserve, mergedMapOutputsCounter);
            this.rawDataLength = rawDataLength;
        }

        public Segment(Configuration conf, FileSystem fs, Path file, long segmentOffset, long segmentLength, CompressionCodec codec, boolean preserve) throws IOException {
            this(conf, fs, file, segmentOffset, segmentLength, codec, preserve, null);
        }

        public Segment(Configuration conf, FileSystem fs, Path file, long segmentOffset, long segmentLength, CompressionCodec codec, boolean preserve, Counters.Counter mergedMapOutputsCounter) throws IOException {
            this.conf = conf;
            this.fs = fs;
            this.file = file;
            this.codec = codec;
            this.preserve = preserve;
            this.segmentOffset = segmentOffset;
            this.segmentLength = segmentLength;
            this.mapOutputsCounter = mergedMapOutputsCounter;
        }

        public Segment(IFile.Reader<K, V> reader, boolean preserve) {
            this(reader, preserve, null);
        }

        public Segment(IFile.Reader<K, V> reader, boolean preserve, long rawDataLength) {
            this(reader, preserve, null);
            this.rawDataLength = rawDataLength;
        }

        public Segment(IFile.Reader<K, V> reader, boolean preserve, Counters.Counter mapOutputsCounter) {
            this.reader = reader;
            this.preserve = preserve;
            this.segmentLength = reader.getLength();
            this.mapOutputsCounter = mapOutputsCounter;
        }

        void init(Counters.Counter readsCounter) throws IOException {
            if (this.reader == null) {
                FSDataInputStream in = this.fs.open(this.file);
                in.seek(this.segmentOffset);
                in = CryptoUtils.wrapIfNecessary(this.conf, in);
                this.reader = new IFile.Reader(this.conf, in, this.segmentLength - (long)CryptoUtils.cryptoPadding(this.conf), this.codec, readsCounter);
            }
            if (this.mapOutputsCounter != null) {
                this.mapOutputsCounter.increment(1L);
            }
        }

        boolean inMemory() {
            return this.fs == null;
        }

        DataInputBuffer getKey() {
            return this.key;
        }

        DataInputBuffer getValue(DataInputBuffer value) throws IOException {
            this.nextRawValue(value);
            return value;
        }

        public long getLength() {
            return this.reader == null ? this.segmentLength : this.reader.getLength();
        }

        public long getRawDataLength() {
            return this.rawDataLength > 0L ? this.rawDataLength : this.getLength();
        }

        boolean nextRawKey() throws IOException {
            return this.reader.nextRawKey(this.key);
        }

        void nextRawValue(DataInputBuffer value) throws IOException {
            this.reader.nextRawValue(value);
        }

        void closeReader() throws IOException {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }

        void close() throws IOException {
            this.closeReader();
            if (!this.preserve && this.fs != null) {
                this.fs.delete(this.file, false);
            }
        }

        public long getPosition() throws IOException {
            return this.reader.getPosition();
        }

        long getActualPosition() throws IOException {
            return this.segmentOffset + this.reader.getPosition();
        }

        IFile.Reader<K, V> getReader() {
            return this.reader;
        }

        void reinitReader(int offset) throws IOException {
            if (!this.inMemory()) {
                this.closeReader();
                this.segmentOffset = offset;
                this.segmentLength = this.fs.getFileStatus(this.file).getLen() - this.segmentOffset;
                this.init(null);
            }
        }
    }
}

