/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.prestosql.hadoop.$internal.org.apache.avro.util.Utf8;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.ProgressSplitsBlock;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.AvroArrayUtils;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletion;
import org.apache.hadoop.mapreduce.util.JobHistoryEventUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.util.SystemClock;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptUnsuccessfulCompletionEvent
implements HistoryEvent {
    private TaskAttemptUnsuccessfulCompletion datum = null;
    private TaskAttemptID attemptId;
    private TaskType taskType;
    private String status;
    private long finishTime;
    private String hostname;
    private int port;
    private String rackName;
    private String error;
    private Counters counters;
    int[][] allSplits;
    int[] clockSplits;
    int[] cpuUsages;
    int[] vMemKbytes;
    int[] physMemKbytes;
    private long startTime;
    private static final Counters EMPTY_COUNTERS = new Counters();

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, int port, String rackName, String error, Counters counters, int[][] allSplits, long startTs) {
        this.attemptId = id;
        this.taskType = taskType;
        this.status = status;
        this.finishTime = finishTime;
        this.hostname = hostname;
        this.port = port;
        this.rackName = rackName;
        this.error = error;
        this.counters = counters;
        this.allSplits = allSplits;
        this.clockSplits = ProgressSplitsBlock.arrayGetWallclockTime(allSplits);
        this.cpuUsages = ProgressSplitsBlock.arrayGetCPUTime(allSplits);
        this.vMemKbytes = ProgressSplitsBlock.arrayGetVMemKbytes(allSplits);
        this.physMemKbytes = ProgressSplitsBlock.arrayGetPhysMemKbytes(allSplits);
        this.startTime = startTs;
    }

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, int port, String rackName, String error, Counters counters, int[][] allSplits) {
        this(id, taskType, status, finishTime, hostname, port, rackName, error, counters, allSplits, SystemClock.getInstance().getTime());
    }

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, String error) {
        this(id, taskType, status, finishTime, hostname, -1, "", error, EMPTY_COUNTERS, null);
    }

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, int port, String rackName, String error, int[][] allSplits) {
        this(id, taskType, status, finishTime, hostname, port, rackName, error, EMPTY_COUNTERS, allSplits);
    }

    TaskAttemptUnsuccessfulCompletionEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new TaskAttemptUnsuccessfulCompletion();
            this.datum.setTaskid(new Utf8(this.attemptId.getTaskID().toString()));
            this.datum.setTaskType(new Utf8(this.taskType.name()));
            this.datum.setAttemptId(new Utf8(this.attemptId.toString()));
            this.datum.setFinishTime(this.finishTime);
            this.datum.setHostname(new Utf8(this.hostname));
            if (this.rackName != null) {
                this.datum.setRackname(new Utf8(this.rackName));
            }
            this.datum.setPort(this.port);
            this.datum.setError(new Utf8(this.error));
            this.datum.setStatus(new Utf8(this.status));
            this.datum.setCounters(EventWriter.toAvro(this.counters));
            this.datum.setClockSplits(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetWallclockTime(this.allSplits)));
            this.datum.setCpuUsages(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetCPUTime(this.allSplits)));
            this.datum.setVMemKbytes(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetVMemKbytes(this.allSplits)));
            this.datum.setPhysMemKbytes(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetPhysMemKbytes(this.allSplits)));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object odatum) {
        this.datum = (TaskAttemptUnsuccessfulCompletion)odatum;
        this.attemptId = TaskAttemptID.forName(this.datum.getAttemptId().toString());
        this.taskType = TaskType.valueOf(this.datum.getTaskType().toString());
        this.finishTime = this.datum.getFinishTime();
        this.hostname = this.datum.getHostname().toString();
        this.rackName = this.datum.getRackname().toString();
        this.port = this.datum.getPort();
        this.status = this.datum.getStatus().toString();
        this.error = this.datum.getError().toString();
        this.counters = EventReader.fromAvro(this.datum.getCounters());
        this.clockSplits = AvroArrayUtils.fromAvro(this.datum.getClockSplits());
        this.cpuUsages = AvroArrayUtils.fromAvro(this.datum.getCpuUsages());
        this.vMemKbytes = AvroArrayUtils.fromAvro(this.datum.getVMemKbytes());
        this.physMemKbytes = AvroArrayUtils.fromAvro(this.datum.getPhysMemKbytes());
    }

    public TaskID getTaskId() {
        return this.attemptId.getTaskID();
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(this.taskType.toString());
    }

    public TaskAttemptID getTaskAttemptId() {
        return this.attemptId;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getRackName() {
        return this.rackName == null ? null : this.rackName.toString();
    }

    public String getError() {
        return this.error.toString();
    }

    public String getTaskStatus() {
        return this.status.toString();
    }

    Counters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        boolean failed = TaskStatus.State.FAILED.toString().equals(this.getTaskStatus());
        return this.getTaskId().getTaskType() == TaskType.MAP ? (failed ? EventType.MAP_ATTEMPT_FAILED : EventType.MAP_ATTEMPT_KILLED) : (failed ? EventType.REDUCE_ATTEMPT_FAILED : EventType.REDUCE_ATTEMPT_KILLED);
    }

    public int[] getClockSplits() {
        return this.clockSplits;
    }

    public int[] getCpuUsages() {
        return this.cpuUsages;
    }

    public int[] getVMemKbytes() {
        return this.vMemKbytes;
    }

    public int[] getPhysMemKbytes() {
        return this.physMemKbytes;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("TASK_TYPE", (Object)this.getTaskType().toString());
        tEvent.addInfo("TASK_ATTEMPT_ID", (Object)(this.getTaskAttemptId() == null ? "" : this.getTaskAttemptId().toString()));
        tEvent.addInfo("FINISH_TIME", (Object)this.getFinishTime());
        tEvent.addInfo("ERROR", (Object)this.getError());
        tEvent.addInfo("STATUS", (Object)this.getTaskStatus());
        tEvent.addInfo("HOSTNAME", (Object)this.getHostname());
        tEvent.addInfo("PORT", (Object)this.getPort());
        tEvent.addInfo("RACK_NAME", (Object)this.getRackName());
        tEvent.addInfo("SHUFFLE_FINISH_TIME", (Object)this.getFinishTime());
        tEvent.addInfo("SORT_FINISH_TIME", (Object)this.getFinishTime());
        tEvent.addInfo("MAP_FINISH_TIME", (Object)this.getFinishTime());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        Set<TimelineMetric> metrics = JobHistoryEventUtils.countersToTimelineMetric(this.getCounters(), this.finishTime);
        return metrics;
    }
}

