/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitterFactory;

public final class NamedCommitterFactory
extends PathOutputCommitterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NamedCommitterFactory.class);

    @Override
    public PathOutputCommitter createOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        Class<? extends PathOutputCommitter> clazz = this.loadCommitterClass(context);
        LOG.debug("Using PathOutputCommitter implementation {}", (Object)clazz);
        try {
            Constructor<? extends PathOutputCommitter> ctor = clazz.getConstructor(Path.class, TaskAttemptContext.class);
            return ctor.newInstance(outputPath, context);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Failed to create " + clazz + ":" + e, e);
        }
    }

    private Class<? extends PathOutputCommitter> loadCommitterClass(JobContext context) throws IOException {
        Preconditions.checkNotNull(context, "null context");
        Configuration conf = context.getConfiguration();
        String value = conf.get("mapreduce.outputcommitter.named.classname", "");
        if (value.isEmpty()) {
            throw new IOException("No committer defined in mapreduce.outputcommitter.named.classname");
        }
        return conf.getClass("mapreduce.outputcommitter.named.classname", FileOutputCommitter.class, PathOutputCommitter.class);
    }
}

