/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store;

import io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.Operation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Hashtable;

public class QueryParams {
    private Hashtable<String, String> params = new Hashtable();
    Operation op = null;
    String apiVersion = null;
    String separator = "";
    String serializedString = null;

    public void add(String name, String value) {
        this.params.put(name, value);
        this.serializedString = null;
    }

    public void setOp(Operation op) {
        this.op = op;
        this.serializedString = null;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        this.serializedString = null;
    }

    public String serialize() {
        if (this.serializedString == null) {
            StringBuilder sb = new StringBuilder();
            if (this.op != null) {
                sb.append(this.separator);
                sb.append("op=");
                sb.append(this.op.name);
                this.separator = "&";
            }
            for (String name : this.params.keySet()) {
                try {
                    sb.append(this.separator);
                    sb.append(URLEncoder.encode(name, "UTF-8"));
                    sb.append('=');
                    sb.append(URLEncoder.encode(this.params.get(name), "UTF-8"));
                    this.separator = "&";
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            if (this.apiVersion != null) {
                sb.append(this.separator);
                sb.append("api-version=");
                sb.append(this.apiVersion);
                this.separator = "&";
            }
            this.serializedString = sb.toString();
        }
        return this.serializedString;
    }
}

