/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.LocationMode;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryInfo;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryPolicyFactory;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageLocation;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.util.Date;

public abstract class RetryPolicy
implements RetryPolicyFactory {
    public static final int DEFAULT_CLIENT_BACKOFF = 30000;
    public static final int DEFAULT_CLIENT_RETRY_COUNT = 3;
    public static final int DEFAULT_MAX_BACKOFF = 90000;
    public static final int DEFAULT_MIN_BACKOFF = 3000;
    protected int deltaBackoffIntervalInMs;
    protected int maximumAttempts;
    protected Date lastPrimaryAttempt = null;
    protected Date lastSecondaryAttempt = null;

    public RetryPolicy() {
    }

    public RetryPolicy(int deltaBackoff, int maxAttempts) {
        this.deltaBackoffIntervalInMs = deltaBackoff;
        this.maximumAttempts = maxAttempts;
    }

    public abstract RetryInfo evaluate(RetryContext var1, OperationContext var2);

    protected boolean evaluateLastAttemptAndSecondaryNotFound(RetryContext retryContext) {
        Utility.assertNotNull("retryContext", retryContext);
        if (retryContext.getLastRequestResult().getTargetLocation() == StorageLocation.PRIMARY) {
            this.lastPrimaryAttempt = retryContext.getLastRequestResult().getStopDate();
        } else {
            this.lastSecondaryAttempt = retryContext.getLastRequestResult().getStopDate();
        }
        return retryContext.getLastRequestResult().getTargetLocation() == StorageLocation.SECONDARY && retryContext.getLastRequestResult().getStatusCode() == 404;
    }

    protected RetryInfo evaluateRetryInfo(RetryContext retryContext, boolean secondaryNotFound, long retryInterval) {
        Date lastAttemptTime;
        RetryInfo retryInfo = new RetryInfo(retryContext);
        if (secondaryNotFound && retryContext.getLocationMode() != LocationMode.SECONDARY_ONLY) {
            retryInfo.setUpdatedLocationMode(LocationMode.PRIMARY_ONLY);
            retryInfo.setTargetLocation(StorageLocation.PRIMARY);
        }
        Date date = lastAttemptTime = retryInfo.getTargetLocation() == StorageLocation.PRIMARY ? this.lastPrimaryAttempt : this.lastSecondaryAttempt;
        if (lastAttemptTime != null) {
            long sinceLastAttempt = new Date().getTime() - lastAttemptTime.getTime() > 0L ? new Date().getTime() - lastAttemptTime.getTime() : 0L;
            retryInfo.setRetryInterval((int)(retryInterval - sinceLastAttempt));
        } else {
            retryInfo.setRetryInterval(0);
        }
        return retryInfo;
    }
}

