/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.ListResponse;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file.CloudFileClient;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file.CloudFileShare;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file.FileShareAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ShareListHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final CloudFileClient serviceClient;
    private final ListResponse<CloudFileShare> response = new ListResponse();
    private FileShareAttributes attributes;
    private String shareName;
    private String snapshotID;

    private ShareListHandler(CloudFileClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    protected static ListResponse<CloudFileShare> getShareList(InputStream stream, CloudFileClient serviceClient) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        ShareListHandler handler = new ShareListHandler(serviceClient);
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.response;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("Share".equals(localName)) {
            this.shareName = "";
            this.snapshotID = null;
            this.attributes = new FileShareAttributes();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String parentNode = null;
        if (!this.elementStack.isEmpty()) {
            parentNode = this.elementStack.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if ("Share".equals(currentNode)) {
            try {
                CloudFileShare retShare = this.serviceClient.getShareReference(this.shareName);
                retShare.setMetadata(this.attributes.getMetadata());
                retShare.setProperties(this.attributes.getProperties());
                retShare.snapshotID = this.snapshotID;
                this.response.getResults().add(retShare);
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
            catch (StorageException e) {
                throw new SAXException(e);
            }
        } else if ("EnumerationResults".equals(parentNode)) {
            if ("Prefix".equals(currentNode)) {
                this.response.setPrefix(value);
            } else if ("Marker".equals(currentNode)) {
                this.response.setMarker(value);
            } else if ("NextMarker".equals(currentNode)) {
                this.response.setNextMarker(value);
            } else if ("MaxResults".equals(currentNode)) {
                this.response.setMaxResults(Integer.parseInt(value));
            }
        } else if ("Share".equals(parentNode)) {
            if ("Name".equals(currentNode)) {
                this.shareName = value;
            } else if ("snapshot".equals(currentNode.toLowerCase())) {
                this.snapshotID = value;
            }
        } else if ("Properties".equals(parentNode)) {
            try {
                this.getProperties(currentNode, value);
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        } else if ("Metadata".equals(parentNode)) {
            if (value == null) {
                value = "";
            }
            this.attributes.getMetadata().put(currentNode, value);
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }

    private void getProperties(String currentNode, String value) throws ParseException {
        if (currentNode.equals("Last-Modified")) {
            this.attributes.getProperties().setLastModified(Utility.parseRFC1123DateFromStringInGMT(value));
        } else if (currentNode.equals("Etag")) {
            this.attributes.getProperties().setEtag(Utility.formatETag(value));
        } else if (currentNode.equals("Quota")) {
            this.attributes.getProperties().setShareQuota(Utility.isNullOrEmpty(value) ? null : Integer.valueOf(Integer.parseInt(value)));
        }
    }
}

