/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.queue;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.BaseRequest;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.ListingContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.UriQueryBuilder;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.queue.QueueListingDetails;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.queue.QueueRequestOptions;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

final class QueueRequest {
    private static final String METADATA = "metadata";
    private static final String POP_RECEIPT = "popreceipt";
    private static final String PEEK_ONLY = "peekonly";
    private static final String NUMBER_OF_MESSAGES = "numofmessages";
    private static final String VISIBILITY_TIMEOUT = "visibilitytimeout";
    private static final String MESSAGE_TTL = "messagettl";

    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        BaseRequest.addMetadata(request, metadata, opContext);
    }

    public static HttpURLConnection clearMessages(URI uri, QueueRequestOptions queueOptions, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        HttpURLConnection request = BaseRequest.createURLConnection(uri, queueOptions, null, opContext);
        request.setRequestMethod("DELETE");
        return request;
    }

    public static HttpURLConnection create(URI uri, QueueRequestOptions queueOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.create(uri, queueOptions, null, opContext);
    }

    public static HttpURLConnection delete(URI uri, QueueRequestOptions queueOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.delete(uri, queueOptions, null, opContext);
    }

    public static HttpURLConnection deleteMessage(URI uri, QueueRequestOptions queueOptions, OperationContext opContext, String popReceipt) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add(POP_RECEIPT, popReceipt);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, queueOptions, builder, opContext);
        request.setRequestMethod("DELETE");
        return request;
    }

    public static HttpURLConnection downloadAttributes(URI uri, QueueRequestOptions queueOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", METADATA);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, queueOptions, builder, opContext);
        retConnection.setRequestMethod("HEAD");
        return retConnection;
    }

    public static HttpURLConnection list(URI uri, QueueRequestOptions queueOptions, OperationContext opContext, ListingContext listingContext, QueueListingDetails detailsIncluded) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = BaseRequest.getListUriQueryBuilder(listingContext);
        if (detailsIncluded == QueueListingDetails.ALL || detailsIncluded == QueueListingDetails.METADATA) {
            builder.add("include", METADATA);
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, queueOptions, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection peekMessages(URI uri, QueueRequestOptions queueOptions, OperationContext opContext, int numberOfMessages) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add(PEEK_ONLY, "true");
        if (numberOfMessages != 0) {
            builder.add(NUMBER_OF_MESSAGES, Integer.toString(numberOfMessages));
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, queueOptions, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection putMessage(URI uri, QueueRequestOptions queueOptions, OperationContext opContext, int visibilityTimeoutInSeconds, int timeToLiveInSeconds) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        if (visibilityTimeoutInSeconds != 0) {
            builder.add(VISIBILITY_TIMEOUT, Integer.toString(visibilityTimeoutInSeconds));
        }
        if (timeToLiveInSeconds != 0) {
            builder.add(MESSAGE_TTL, Integer.toString(timeToLiveInSeconds));
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, queueOptions, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("POST");
        return request;
    }

    public static HttpURLConnection retrieveMessages(URI uri, QueueRequestOptions queueOptions, OperationContext opContext, int numberOfMessages, int visibilityTimeoutInSeconds) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        if (numberOfMessages != 0) {
            builder.add(NUMBER_OF_MESSAGES, Integer.toString(numberOfMessages));
        }
        builder.add(VISIBILITY_TIMEOUT, Integer.toString(visibilityTimeoutInSeconds));
        HttpURLConnection request = BaseRequest.createURLConnection(uri, queueOptions, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection setMetadata(URI uri, QueueRequestOptions queueOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.setMetadata(uri, queueOptions, null, opContext);
    }

    public static HttpURLConnection updateMessage(URI uri, QueueRequestOptions queueOptions, OperationContext opContext, String popReceipt, int visibilityTimeoutInSeconds) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add(POP_RECEIPT, popReceipt);
        builder.add(VISIBILITY_TIMEOUT, Integer.toString(visibilityTimeoutInSeconds));
        HttpURLConnection request = BaseRequest.createURLConnection(uri, queueOptions, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        return request;
    }

    public static HttpURLConnection setAcl(URI uri, QueueRequestOptions queueOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, queueOptions, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        return request;
    }

    public static HttpURLConnection getAcl(URI uri, QueueRequestOptions queueOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, queueOptions, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    private QueueRequest() {
    }
}

