/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.asn1;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.EnumType;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.Tag;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.TaggingOption;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Type;

public class Asn1FieldInfo {
    private EnumType index;
    private int tagNo = -1;
    private boolean isImplicit;
    private Class<? extends Asn1Type> type;
    private Tag tag = null;

    public Asn1FieldInfo(EnumType index, Class<? extends Asn1Type> type, boolean isImplicit) {
        this(index, index.getValue(), type, isImplicit);
    }

    public Asn1FieldInfo(EnumType index, int tagNo, Class<? extends Asn1Type> type, boolean isImplicit) {
        this.index = index;
        this.tagNo = tagNo;
        this.type = type;
        this.isImplicit = isImplicit;
    }

    public Asn1FieldInfo(EnumType index, Class<? extends Asn1Type> type) {
        this.index = index;
        this.type = type;
        this.tagNo = -1;
    }

    public boolean isTagged() {
        return this.tagNo != -1;
    }

    public TaggingOption getTaggingOption() {
        if (this.isImplicit) {
            return TaggingOption.newImplicitContextSpecific(this.tagNo);
        }
        return TaggingOption.newExplicitContextSpecific(this.tagNo);
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public EnumType getIndex() {
        return this.index;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public Asn1Type createFieldValue() {
        try {
            return this.type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad field type provided, no default constructor?", e);
        }
    }

    public Tag getFieldTag() {
        if (this.tag == null) {
            Asn1Type fieldValue = this.createFieldValue();
            this.tag = fieldValue.tag();
        }
        return this.tag;
    }

    public Class<? extends Asn1Type> getType() {
        return this.type;
    }
}

