/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.Asn1Dumper;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.EnumType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationType;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;

public class AuthorizationDataWrapper
extends AuthorizationDataEntry {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationDataWrapper.class);
    private AuthorizationData authorizationData;

    public AuthorizationDataWrapper(WrapperType type) {
        super(Enum.valueOf(AuthorizationType.class, type.name()));
    }

    public AuthorizationDataWrapper(WrapperType type, AuthorizationData authzData) throws IOException {
        super(Enum.valueOf(AuthorizationType.class, type.name()));
        this.authorizationData = authzData;
        if (authzData != null) {
            this.setAuthzData(authzData.encode());
        } else {
            this.setAuthzData(null);
        }
    }

    public AuthorizationData getAuthorizationData() throws IOException {
        AuthorizationData result;
        if (this.authorizationData != null) {
            result = this.authorizationData;
        } else {
            result = new AuthorizationData();
            result.decode(this.getAuthzData());
        }
        return result;
    }

    public void setAuthorizationData(AuthorizationData authzData) throws IOException {
        this.setAuthzData(authzData.encode());
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        super.dumpWith(dumper, indents);
        dumper.newLine();
        try {
            this.getAuthorizationData().dumpWith(dumper, indents + 8);
        }
        catch (IOException e) {
            LOG.error("Fail to get authorization data. " + e);
        }
    }

    public static enum WrapperType implements EnumType
    {
        AD_IF_RELEVANT(AuthorizationType.AD_IF_RELEVANT.getValue()),
        AD_MANDATORY_FOR_KDC(AuthorizationType.AD_MANDATORY_FOR_KDC.getValue());

        private final int value;

        private WrapperType(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

