/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.xdr.type;

import io.prestosql.hadoop.$internal.org.apache.kerby.xdr.XdrDataType;
import io.prestosql.hadoop.$internal.org.apache.kerby.xdr.type.XdrSimple;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class XdrBoolean
extends XdrSimple<Boolean> {
    private static final byte[] TRUE_BYTE = new byte[]{0, 0, 0, 1};
    private static final byte[] FALSE_BYTE = new byte[]{0, 0, 0, 0};
    public static final XdrBoolean TRUE = new XdrBoolean(true);
    public static final XdrBoolean FALSE = new XdrBoolean(false);

    public XdrBoolean() {
        this((Boolean)null);
    }

    public XdrBoolean(Boolean value) {
        super(XdrDataType.BOOLEAN, value);
    }

    @Override
    protected int encodingBodyLength() {
        return 4;
    }

    @Override
    protected void toBytes() {
        this.setBytes((Boolean)this.getValue() != false ? TRUE_BYTE : FALSE_BYTE);
    }

    @Override
    protected void toValue() throws IOException {
        byte[] bytes;
        if (this.getBytes().length != 4) {
            byte[] boolBytes = ByteBuffer.allocate(4).put(this.getBytes(), 0, 4).array();
            this.setBytes(boolBytes);
        }
        if (Arrays.equals(bytes = this.getBytes(), TRUE_BYTE)) {
            this.setValue(true);
        } else if (Arrays.equals(bytes, FALSE_BYTE)) {
            this.setValue(false);
        } else {
            throw new IOException("Fail to decode boolean type: " + Arrays.toString(bytes));
        }
    }
}

