/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.xdr.type;

import io.prestosql.hadoop.$internal.org.apache.kerby.xdr.EnumType;
import io.prestosql.hadoop.$internal.org.apache.kerby.xdr.XdrDataType;
import io.prestosql.hadoop.$internal.org.apache.kerby.xdr.type.XdrSimple;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public abstract class XdrEnumerated<T extends EnumType>
extends XdrSimple<T> {
    public XdrEnumerated() {
        this(null);
    }

    public XdrEnumerated(T value) {
        super(XdrDataType.ENUM, value);
    }

    @Override
    protected void toBytes() {
        byte[] bytes = ByteBuffer.allocate(4).putInt(((EnumType)this.getValue()).getValue()).array();
        this.setBytes(bytes);
    }

    @Override
    protected void toValue() {
        EnumType[] allValues;
        if (this.getBytes().length != 4) {
            byte[] intBytes = ByteBuffer.allocate(4).put(this.getBytes(), 0, 4).array();
            this.setBytes(intBytes);
        }
        BigInteger biVal = new BigInteger(this.getBytes());
        int iVal = biVal.intValue();
        for (EnumType val : allValues = this.getAllEnumValues()) {
            if (val.getValue() != iVal) continue;
            this.setValue(val);
        }
    }

    protected abstract EnumType[] getAllEnumValues();
}

