/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.ADLFileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Syncable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class AdlFsOutputStream
extends OutputStream
implements Syncable {
    private final ADLFileOutputStream out;

    public AdlFsOutputStream(ADLFileOutputStream out, Configuration configuration) throws IOException {
        this.out = out;
        out.setBufferSize(configuration.getInt("adl.feature.client.cache.drop.behind.writes", 0x400000));
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public synchronized void close() throws IOException {
        this.out.close();
    }

    public synchronized void sync() throws IOException {
        this.out.flush();
    }

    @Override
    public synchronized void hflush() throws IOException {
        this.out.flush();
    }

    @Override
    public synchronized void hsync() throws IOException {
        this.out.flush();
    }
}

