/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.ErrorReceivingResponseEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RequestResult;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.ResponseReceivedEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.SendingRequestEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageEvent;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.net.HttpURLConnection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.BlobOperationDescriptor;
import org.apache.hadoop.fs.azure.ClientThrottlingAnalyzer;

@InterfaceAudience.Private
final class ClientThrottlingIntercept {
    private static final Logger LOG = LoggerFactory.getLogger(ClientThrottlingIntercept.class);
    private static ClientThrottlingIntercept singleton = null;
    private ClientThrottlingAnalyzer readThrottler = new ClientThrottlingAnalyzer("read");
    private ClientThrottlingAnalyzer writeThrottler = new ClientThrottlingAnalyzer("write");

    private ClientThrottlingIntercept() {
        LOG.debug("Client-side throttling is enabled for the WASB file system.");
    }

    static synchronized void initializeSingleton() {
        if (singleton == null) {
            singleton = new ClientThrottlingIntercept();
        }
    }

    static void hook(OperationContext context) {
        context.getErrorReceivingResponseEventHandler().addListener(new ErrorReceivingResponseEventHandler());
        context.getSendingRequestEventHandler().addListener(new SendingRequestEventHandler());
        context.getResponseReceivedEventHandler().addListener(new ResponseReceivedEventHandler());
    }

    private static void updateMetrics(HttpURLConnection conn, RequestResult result) {
        BlobOperationDescriptor.OperationType operationType = BlobOperationDescriptor.getOperationType(conn);
        int status = result.getStatusCode();
        long contentLength = 0L;
        boolean isFailedOperation = status < 200 || status >= 500;
        switch (operationType) {
            case AppendBlock: 
            case PutBlock: 
            case PutPage: {
                contentLength = BlobOperationDescriptor.getContentLengthIfKnown(conn, operationType);
                if (contentLength <= 0L) break;
                ClientThrottlingIntercept.singleton.writeThrottler.addBytesTransferred(contentLength, isFailedOperation);
                break;
            }
            case GetBlob: {
                contentLength = BlobOperationDescriptor.getContentLengthIfKnown(conn, operationType);
                if (contentLength <= 0L) break;
                ClientThrottlingIntercept.singleton.readThrottler.addBytesTransferred(contentLength, isFailedOperation);
                break;
            }
        }
    }

    public static void errorReceivingResponse(ErrorReceivingResponseEvent event) {
        ClientThrottlingIntercept.updateMetrics((HttpURLConnection)event.getConnectionObject(), event.getRequestResult());
    }

    public static void sendingRequest(SendingRequestEvent event) {
        BlobOperationDescriptor.OperationType operationType = BlobOperationDescriptor.getOperationType((HttpURLConnection)event.getConnectionObject());
        switch (operationType) {
            case GetBlob: {
                ClientThrottlingIntercept.singleton.readThrottler.suspendIfNecessary();
                break;
            }
            case AppendBlock: 
            case PutBlock: 
            case PutPage: {
                ClientThrottlingIntercept.singleton.writeThrottler.suspendIfNecessary();
                break;
            }
        }
    }

    public static void responseReceived(ResponseReceivedEvent event) {
        ClientThrottlingIntercept.updateMetrics((HttpURLConnection)event.getConnectionObject(), event.getRequestResult());
    }

    @InterfaceAudience.Private
    static class ResponseReceivedEventHandler
    extends StorageEvent<ResponseReceivedEvent> {
        ResponseReceivedEventHandler() {
        }

        @Override
        public void eventOccurred(ResponseReceivedEvent event) {
            singleton;
            ClientThrottlingIntercept.responseReceived(event);
        }
    }

    @InterfaceAudience.Private
    static class SendingRequestEventHandler
    extends StorageEvent<SendingRequestEvent> {
        SendingRequestEventHandler() {
        }

        @Override
        public void eventOccurred(SendingRequestEvent event) {
            singleton;
            ClientThrottlingIntercept.sendingRequest(event);
        }
    }

    @InterfaceAudience.Private
    static class ErrorReceivingResponseEventHandler
    extends StorageEvent<ErrorReceivingResponseEvent> {
        ErrorReceivingResponseEventHandler() {
        }

        @Override
        public void eventOccurred(ErrorReceivingResponseEvent event) {
            singleton;
            ClientThrottlingIntercept.errorReceivingResponse(event);
        }
    }
}

