/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;

@InterfaceAudience.Private
public final class BandwidthGaugeUpdater {
    public static final Log LOG = LogFactory.getLog(BandwidthGaugeUpdater.class);
    public static final String THREAD_NAME = "AzureNativeFilesystemStore-UploadBandwidthUpdater";
    private static final int DEFAULT_WINDOW_SIZE_MS = 1000;
    private static final int PROCESS_QUEUE_INITIAL_CAPACITY = 1000;
    private int windowSizeMs;
    private ArrayList<BlockTransferWindow> allBlocksWritten = BandwidthGaugeUpdater.createNewToProcessQueue();
    private ArrayList<BlockTransferWindow> allBlocksRead = BandwidthGaugeUpdater.createNewToProcessQueue();
    private final Object blocksWrittenLock = new Object();
    private final Object blocksReadLock = new Object();
    private final AzureFileSystemInstrumentation instrumentation;
    private Thread uploadBandwidthUpdater;
    private volatile boolean suppressAutoUpdate = false;

    public BandwidthGaugeUpdater(AzureFileSystemInstrumentation instrumentation) {
        this(instrumentation, 1000, false);
    }

    public BandwidthGaugeUpdater(AzureFileSystemInstrumentation instrumentation, int windowSizeMs, boolean manualUpdateTrigger) {
        this.windowSizeMs = windowSizeMs;
        this.instrumentation = instrumentation;
        if (!manualUpdateTrigger) {
            this.uploadBandwidthUpdater = new Thread((Runnable)new UploadBandwidthUpdater(), THREAD_NAME);
            this.uploadBandwidthUpdater.setDaemon(true);
            this.uploadBandwidthUpdater.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUploaded(Date startDate, Date endDate, long length) {
        Object object = this.blocksWrittenLock;
        synchronized (object) {
            this.allBlocksWritten.add(new BlockTransferWindow(startDate, endDate, length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockDownloaded(Date startDate, Date endDate, long length) {
        Object object = this.blocksReadLock;
        synchronized (object) {
            this.allBlocksRead.add(new BlockTransferWindow(startDate, endDate, length));
        }
    }

    private static ArrayList<BlockTransferWindow> createNewToProcessQueue() {
        return new ArrayList<BlockTransferWindow>(1000);
    }

    private void updateBytesTransferred(boolean updateWrite, long bytes) {
        if (updateWrite) {
            this.instrumentation.updateBytesWrittenInLastSecond(bytes);
        } else {
            this.instrumentation.updateBytesReadInLastSecond(bytes);
        }
    }

    private void updateBytesTransferRate(boolean updateWrite, long bytesPerSecond) {
        if (updateWrite) {
            this.instrumentation.currentUploadBytesPerSecond(bytesPerSecond);
        } else {
            this.instrumentation.currentDownloadBytesPerSecond(bytesPerSecond);
        }
    }

    public void suppressAutoUpdate() {
        this.suppressAutoUpdate = true;
    }

    public void resumeAutoUpdate() {
        this.suppressAutoUpdate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerUpdate(boolean updateWrite) {
        ArrayList<BlockTransferWindow> toProcess = null;
        Object object = updateWrite ? this.blocksWrittenLock : this.blocksReadLock;
        synchronized (object) {
            if (updateWrite && !this.allBlocksWritten.isEmpty()) {
                toProcess = this.allBlocksWritten;
                this.allBlocksWritten = BandwidthGaugeUpdater.createNewToProcessQueue();
            } else if (!updateWrite && !this.allBlocksRead.isEmpty()) {
                toProcess = this.allBlocksRead;
                this.allBlocksRead = BandwidthGaugeUpdater.createNewToProcessQueue();
            }
        }
        if (toProcess == null) {
            this.updateBytesTransferred(updateWrite, 0L);
            this.updateBytesTransferRate(updateWrite, 0L);
            return;
        }
        long cutoffTime = new Date().getTime() - (long)this.windowSizeMs;
        long maxSingleBlockTransferRate = 0L;
        long bytesInLastSecond = 0L;
        for (BlockTransferWindow currentWindow : toProcess) {
            long windowDuration = currentWindow.getEndDate().getTime() - currentWindow.getStartDate().getTime();
            if (windowDuration == 0L) {
                windowDuration = 1L;
            }
            if (currentWindow.getStartDate().getTime() > cutoffTime) {
                bytesInLastSecond += currentWindow.bytesTransferred;
            } else if (currentWindow.getEndDate().getTime() > cutoffTime) {
                long adjustedBytes = currentWindow.getBytesTransferred() * (currentWindow.getEndDate().getTime() - cutoffTime) / windowDuration;
                bytesInLastSecond += adjustedBytes;
            }
            long currentBlockTransferRate = currentWindow.getBytesTransferred() * 1000L / windowDuration;
            maxSingleBlockTransferRate = Math.max(maxSingleBlockTransferRate, currentBlockTransferRate);
        }
        this.updateBytesTransferred(updateWrite, bytesInLastSecond);
        long aggregateTransferRate = bytesInLastSecond;
        long maxObservedTransferRate = Math.max(aggregateTransferRate, maxSingleBlockTransferRate);
        this.updateBytesTransferRate(updateWrite, maxObservedTransferRate);
    }

    public void close() {
        if (this.uploadBandwidthUpdater != null) {
            this.uploadBandwidthUpdater.interrupt();
            try {
                this.uploadBandwidthUpdater.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.uploadBandwidthUpdater = null;
        }
    }

    private final class UploadBandwidthUpdater
    implements Runnable {
        private UploadBandwidthUpdater() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(BandwidthGaugeUpdater.this.windowSizeMs);
                    if (BandwidthGaugeUpdater.this.suppressAutoUpdate) continue;
                    BandwidthGaugeUpdater.this.triggerUpdate(true);
                    BandwidthGaugeUpdater.this.triggerUpdate(false);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private static final class BlockTransferWindow {
        private final Date startDate;
        private final Date endDate;
        private final long bytesTransferred;

        public BlockTransferWindow(Date startDate, Date endDate, long bytesTransferred) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.bytesTransferred = bytesTransferred;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }
    }
}

