/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.prestosql.hadoop.$internal.htrace.core.TraceScope;
import io.prestosql.hadoop.$internal.htrace.core.Tracer;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.inotify.EventBatch;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.inotify.MissingEventsException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class DFSInotifyEventInputStream {
    public static final Logger LOG = LoggerFactory.getLogger(DFSInotifyEventInputStream.class);
    private final ClientProtocol namenode;
    private Iterator<EventBatch> it;
    private long lastReadTxid;
    private long syncTxid;
    private Random rng = new Random();
    private final Tracer tracer;
    private static final int INITIAL_WAIT_MS = 10;

    DFSInotifyEventInputStream(ClientProtocol namenode, Tracer tracer) throws IOException {
        this(namenode, tracer, namenode.getCurrentEditLogTxid());
    }

    DFSInotifyEventInputStream(ClientProtocol namenode, Tracer tracer, long lastReadTxid) {
        this.namenode = namenode;
        this.it = Collections.emptyIterator();
        this.lastReadTxid = lastReadTxid;
        this.tracer = tracer;
    }

    public EventBatch poll() throws IOException, MissingEventsException {
        try (TraceScope ignored = this.tracer.newScope("inotifyPoll");){
            EventBatch eventBatch;
            if (this.lastReadTxid == -1L) {
                LOG.debug("poll(): lastReadTxid is -1, reading current txid from NN");
                this.lastReadTxid = this.namenode.getCurrentEditLogTxid();
                EventBatch eventBatch2 = null;
                return eventBatch2;
            }
            if (!this.it.hasNext()) {
                EventBatchList el = this.namenode.getEditsFromTxid(this.lastReadTxid + 1L);
                if (el.getLastTxid() != -1L) {
                    this.syncTxid = el.getSyncTxid();
                    this.it = el.getBatches().iterator();
                    long formerLastReadTxid = this.lastReadTxid;
                    this.lastReadTxid = el.getLastTxid();
                    if (el.getFirstTxid() != formerLastReadTxid + 1L) {
                        throw new MissingEventsException(formerLastReadTxid + 1L, el.getFirstTxid());
                    }
                } else {
                    LOG.debug("poll(): read no edits from the NN when requesting edits after txid {}", (Object)this.lastReadTxid);
                    EventBatch eventBatch3 = null;
                    return eventBatch3;
                }
            }
            if (this.it.hasNext()) {
                eventBatch = this.it.next();
                return eventBatch;
            }
            eventBatch = null;
            return eventBatch;
        }
    }

    public long getTxidsBehindEstimate() {
        if (this.syncTxid == 0L) {
            return -1L;
        }
        assert (this.syncTxid >= this.lastReadTxid);
        return this.syncTxid - this.lastReadTxid;
    }

    public EventBatch poll(long time, TimeUnit tu) throws IOException, InterruptedException, MissingEventsException {
        EventBatch next;
        try (TraceScope ignored = this.tracer.newScope("inotifyPollWithTimeout");){
            long initialTime = Time.monotonicNow();
            long totalWait = TimeUnit.MILLISECONDS.convert(time, tu);
            long nextWait = 10L;
            while ((next = this.poll()) == null) {
                long timeLeft = totalWait - (Time.monotonicNow() - initialTime);
                if (timeLeft <= 0L) {
                    LOG.debug("timed poll(): timed out");
                    break;
                }
                nextWait = timeLeft < nextWait * 2L ? timeLeft : (nextWait *= 2L);
                LOG.debug("timed poll(): poll() returned null, sleeping for {} ms", (Object)nextWait);
                Thread.sleep(nextWait);
            }
        }
        return next;
    }

    public EventBatch take() throws IOException, InterruptedException, MissingEventsException {
        EventBatch next;
        try (TraceScope ignored = this.tracer.newScope("inotifyTake");){
            int nextWaitMin = 10;
            while ((next = this.poll()) == null) {
                int sleepTime = nextWaitMin + this.rng.nextInt(nextWaitMin);
                LOG.debug("take(): poll() returned null, sleeping for {} ms", (Object)sleepTime);
                Thread.sleep(sleepTime);
                nextWaitMin = Math.min(60000, nextWaitMin * 2);
            }
        }
        return next;
    }
}

