/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffListByArrayList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffListBySkipList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;

public abstract class DirectoryDiffListFactory {
    private static volatile IntFunction<DiffList<DirectoryWithSnapshotFeature.DirectoryDiff>> constructor = c -> new DiffListByArrayList(c);
    private static volatile int skipInterval;
    private static volatile int maxLevels;

    public static DiffList<DirectoryWithSnapshotFeature.DirectoryDiff> createDiffList(int capacity) {
        return constructor.apply(capacity);
    }

    public static void init(int interval, int maxSkipLevels, Logger log) {
        skipInterval = interval;
        maxLevels = maxSkipLevels;
        if (maxLevels > 0) {
            constructor = c -> new DiffListBySkipList(c);
            log.info("SkipList is enabled with skipInterval=" + skipInterval + ", maxLevels=" + maxLevels);
        } else {
            constructor = c -> new DiffListByArrayList(c);
            log.info("SkipList is disabled");
        }
    }

    public static int randomLevel() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int level = 0; level < maxLevels; ++level) {
            if (((Random)r).nextInt(skipInterval) <= 0) continue;
            return level;
        }
        return maxLevels;
    }

    private DirectoryDiffListFactory() {
    }
}

