/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.sps;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.sps.FileCollector;
import org.apache.hadoop.hdfs.server.namenode.sps.ItemInfo;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;

@InterfaceAudience.Private
public class ExternalSPSFilePathCollector
implements FileCollector {
    public static final Logger LOG = LoggerFactory.getLogger(ExternalSPSFilePathCollector.class);
    private DistributedFileSystem dfs;
    private SPSService service;
    private int maxQueueLimitToScan;

    public ExternalSPSFilePathCollector(SPSService service) {
        this.service = service;
        this.maxQueueLimitToScan = service.getConf().getInt("dfs.storage.policy.satisfier.queue.limit", 1000);
        try {
            this.dfs = this.getFS(service.getConf());
        }
        catch (IOException e) {
            LOG.error("Unable to get the filesystem. Make sure Namenode running and configured namenode address is correct.", e);
        }
    }

    private DistributedFileSystem getFS(Configuration conf) throws IOException {
        return (DistributedFileSystem)FileSystem.get(FileSystem.getDefaultUri(conf), conf);
    }

    private long processPath(Long startID, String childPath) {
        long pendingWorkCount = 0L;
        byte[] lastReturnedName = HdfsFileStatus.EMPTY_NAME;
        while (true) {
            DirectoryListing children;
            try {
                children = this.dfs.getClient().listPaths(childPath, lastReturnedName, false);
            }
            catch (IOException e) {
                LOG.warn("Failed to list directory " + childPath + ". Ignore the directory and continue.", e);
                return pendingWorkCount;
            }
            if (children == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The scanning start dir/sub dir " + childPath + " does not have childrens.");
                }
                return pendingWorkCount;
            }
            for (HdfsFileStatus child : children.getPartialListing()) {
                if (child.isFile()) {
                    this.service.addFileToProcess(new ItemInfo(startID, child.getFileId()), false);
                    this.checkProcessingQueuesFree();
                    ++pendingWorkCount;
                    continue;
                }
                String childFullPathName = child.getFullName(childPath);
                if (!child.isDirectory()) continue;
                if (!childFullPathName.endsWith("/")) {
                    childFullPathName = childFullPathName + "/";
                }
                pendingWorkCount += this.processPath(startID, childFullPathName);
            }
            if (!children.hasMore()) break;
            lastReturnedName = children.getLastName();
        }
        return pendingWorkCount;
    }

    private void checkProcessingQueuesFree() {
        int remainingCapacity = this.remainingCapacity();
        while (remainingCapacity <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting for storageMovementNeeded queue to be free!");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            remainingCapacity = this.remainingCapacity();
        }
    }

    public int remainingCapacity() {
        int size = this.service.processingQueueSize();
        int remainingSize = 0;
        if (size < this.maxQueueLimitToScan) {
            remainingSize = this.maxQueueLimitToScan - size;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("SPS processing Q -> maximum capacity:{}, current size:{}, remaining size:{}", this.maxQueueLimitToScan, size, remainingSize);
        }
        return remainingSize;
    }

    @Override
    public void scanAndCollectFiles(long pathId) throws IOException {
        if (this.dfs == null) {
            this.dfs = this.getFS(this.service.getConf());
        }
        Path filePath = DFSUtilClient.makePathFromFileId(pathId);
        long pendingSatisfyItemsCount = this.processPath(pathId, filePath.toString());
        if (pendingSatisfyItemsCount <= 0L) {
            LOG.debug("There is no pending items to satisfy the given path inodeId:{}", (Object)pathId);
            this.service.addAllFilesToProcess(pathId, new ArrayList<ItemInfo>(), true);
        } else {
            this.service.markScanCompletedForPath(pathId);
        }
    }
}

