/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdatedEvent;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobHistoryParser
implements HistoryEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JobHistoryParser.class);
    private final FSDataInputStream in;
    private JobInfo info = null;
    private IOException parseException = null;

    public JobHistoryParser(FileSystem fs, String file) throws IOException {
        this(fs, new Path(file));
    }

    public JobHistoryParser(FileSystem fs, Path historyFile) throws IOException {
        this(fs.open(historyFile));
    }

    public JobHistoryParser(FSDataInputStream in) {
        this.in = in;
    }

    public synchronized void parse(HistoryEventHandler handler) throws IOException {
        this.parse(new EventReader(this.in), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public synchronized void parse(EventReader reader, HistoryEventHandler handler) throws IOException {
        int eventCtr = 0;
        try {
            HistoryEvent event;
            while ((event = reader.getNextEvent()) != null) {
                handler.handleEvent(event);
                ++eventCtr;
            }
        }
        catch (IOException ioe) {
            LOG.info("Caught exception parsing history file after " + eventCtr + " events", ioe);
            this.parseException = ioe;
        }
        finally {
            this.in.close();
        }
    }

    public synchronized JobInfo parse() throws IOException {
        return this.parse(new EventReader(this.in));
    }

    @InterfaceAudience.Private
    public synchronized JobInfo parse(EventReader reader) throws IOException {
        if (this.info != null) {
            return this.info;
        }
        this.info = new JobInfo();
        this.parse(reader, this);
        return this.info;
    }

    public synchronized IOException getParseException() {
        return this.parseException;
    }

    @Override
    public void handleEvent(HistoryEvent event) {
        EventType type = event.getEventType();
        switch (type) {
            case JOB_SUBMITTED: {
                this.handleJobSubmittedEvent((JobSubmittedEvent)event);
                break;
            }
            case JOB_STATUS_CHANGED: {
                break;
            }
            case JOB_INFO_CHANGED: {
                this.handleJobInfoChangeEvent((JobInfoChangeEvent)event);
                break;
            }
            case JOB_INITED: {
                this.handleJobInitedEvent((JobInitedEvent)event);
                break;
            }
            case JOB_PRIORITY_CHANGED: {
                this.handleJobPriorityChangeEvent((JobPriorityChangeEvent)event);
                break;
            }
            case JOB_QUEUE_CHANGED: {
                this.handleJobQueueChangeEvent((JobQueueChangeEvent)event);
                break;
            }
            case JOB_FAILED: 
            case JOB_KILLED: 
            case JOB_ERROR: {
                this.handleJobFailedEvent((JobUnsuccessfulCompletionEvent)event);
                break;
            }
            case JOB_FINISHED: {
                this.handleJobFinishedEvent((JobFinishedEvent)event);
                break;
            }
            case TASK_STARTED: {
                this.handleTaskStartedEvent((TaskStartedEvent)event);
                break;
            }
            case TASK_FAILED: {
                this.handleTaskFailedEvent((TaskFailedEvent)event);
                break;
            }
            case TASK_UPDATED: {
                this.handleTaskUpdatedEvent((TaskUpdatedEvent)event);
                break;
            }
            case TASK_FINISHED: {
                this.handleTaskFinishedEvent((TaskFinishedEvent)event);
                break;
            }
            case MAP_ATTEMPT_STARTED: 
            case CLEANUP_ATTEMPT_STARTED: 
            case REDUCE_ATTEMPT_STARTED: 
            case SETUP_ATTEMPT_STARTED: {
                this.handleTaskAttemptStartedEvent((TaskAttemptStartedEvent)event);
                break;
            }
            case MAP_ATTEMPT_FAILED: 
            case CLEANUP_ATTEMPT_FAILED: 
            case REDUCE_ATTEMPT_FAILED: 
            case SETUP_ATTEMPT_FAILED: 
            case MAP_ATTEMPT_KILLED: 
            case CLEANUP_ATTEMPT_KILLED: 
            case REDUCE_ATTEMPT_KILLED: 
            case SETUP_ATTEMPT_KILLED: {
                this.handleTaskAttemptFailedEvent((TaskAttemptUnsuccessfulCompletionEvent)event);
                break;
            }
            case MAP_ATTEMPT_FINISHED: {
                this.handleMapAttemptFinishedEvent((MapAttemptFinishedEvent)event);
                break;
            }
            case REDUCE_ATTEMPT_FINISHED: {
                this.handleReduceAttemptFinishedEvent((ReduceAttemptFinishedEvent)event);
                break;
            }
            case SETUP_ATTEMPT_FINISHED: 
            case CLEANUP_ATTEMPT_FINISHED: {
                this.handleTaskAttemptFinishedEvent((TaskAttemptFinishedEvent)event);
                break;
            }
            case AM_STARTED: {
                this.handleAMStartedEvent((AMStartedEvent)event);
                break;
            }
        }
    }

    private void handleTaskAttemptFinishedEvent(TaskAttemptFinishedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        TaskAttemptInfo attemptInfo = taskInfo.attemptsMap.get(event.getAttemptId());
        attemptInfo.finishTime = event.getFinishTime();
        attemptInfo.status = StringInterner.weakIntern(event.getTaskStatus());
        attemptInfo.state = StringInterner.weakIntern(event.getState());
        attemptInfo.counters = event.getCounters();
        attemptInfo.hostname = StringInterner.weakIntern(event.getHostname());
        this.info.completedTaskAttemptsMap.put(event.getAttemptId(), attemptInfo);
    }

    private void handleReduceAttemptFinishedEvent(ReduceAttemptFinishedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        TaskAttemptInfo attemptInfo = taskInfo.attemptsMap.get(event.getAttemptId());
        attemptInfo.finishTime = event.getFinishTime();
        attemptInfo.status = StringInterner.weakIntern(event.getTaskStatus());
        attemptInfo.state = StringInterner.weakIntern(event.getState());
        attemptInfo.shuffleFinishTime = event.getShuffleFinishTime();
        attemptInfo.sortFinishTime = event.getSortFinishTime();
        attemptInfo.counters = event.getCounters();
        attemptInfo.hostname = StringInterner.weakIntern(event.getHostname());
        attemptInfo.port = event.getPort();
        attemptInfo.rackname = StringInterner.weakIntern(event.getRackName());
        this.info.completedTaskAttemptsMap.put(event.getAttemptId(), attemptInfo);
    }

    private void handleMapAttemptFinishedEvent(MapAttemptFinishedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        TaskAttemptInfo attemptInfo = taskInfo.attemptsMap.get(event.getAttemptId());
        attemptInfo.finishTime = event.getFinishTime();
        attemptInfo.status = StringInterner.weakIntern(event.getTaskStatus());
        attemptInfo.state = StringInterner.weakIntern(event.getState());
        attemptInfo.mapFinishTime = event.getMapFinishTime();
        attemptInfo.counters = event.getCounters();
        attemptInfo.hostname = StringInterner.weakIntern(event.getHostname());
        attemptInfo.port = event.getPort();
        attemptInfo.rackname = StringInterner.weakIntern(event.getRackName());
        this.info.completedTaskAttemptsMap.put(event.getAttemptId(), attemptInfo);
    }

    private void handleTaskAttemptFailedEvent(TaskAttemptUnsuccessfulCompletionEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        if (taskInfo == null) {
            LOG.warn("TaskInfo is null for TaskAttemptUnsuccessfulCompletionEvent taskId:  " + event.getTaskId().toString());
            return;
        }
        TaskAttemptInfo attemptInfo = taskInfo.attemptsMap.get(event.getTaskAttemptId());
        if (attemptInfo == null) {
            LOG.warn("AttemptInfo is null for TaskAttemptUnsuccessfulCompletionEvent taskAttemptId:  " + event.getTaskAttemptId().toString());
            return;
        }
        attemptInfo.finishTime = event.getFinishTime();
        attemptInfo.error = StringInterner.weakIntern(event.getError());
        attemptInfo.status = StringInterner.weakIntern(event.getTaskStatus());
        attemptInfo.hostname = StringInterner.weakIntern(event.getHostname());
        attemptInfo.port = event.getPort();
        attemptInfo.rackname = StringInterner.weakIntern(event.getRackName());
        attemptInfo.shuffleFinishTime = event.getFinishTime();
        attemptInfo.sortFinishTime = event.getFinishTime();
        attemptInfo.mapFinishTime = event.getFinishTime();
        attemptInfo.counters = event.getCounters();
        if (TaskStatus.State.SUCCEEDED.toString().equals(taskInfo.status) && attemptInfo.getAttemptId().equals(taskInfo.getSuccessfulAttemptId())) {
            taskInfo.counters = null;
            taskInfo.finishTime = -1L;
            taskInfo.status = null;
            taskInfo.successfulAttemptId = null;
        }
        this.info.completedTaskAttemptsMap.put(event.getTaskAttemptId(), attemptInfo);
    }

    private void handleTaskAttemptStartedEvent(TaskAttemptStartedEvent event) {
        TaskAttemptID attemptId = event.getTaskAttemptId();
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        TaskAttemptInfo attemptInfo = new TaskAttemptInfo();
        attemptInfo.startTime = event.getStartTime();
        attemptInfo.attemptId = event.getTaskAttemptId();
        attemptInfo.httpPort = event.getHttpPort();
        attemptInfo.trackerName = StringInterner.weakIntern(event.getTrackerName());
        attemptInfo.taskType = event.getTaskType();
        attemptInfo.shufflePort = event.getShufflePort();
        attemptInfo.containerId = event.getContainerId();
        taskInfo.attemptsMap.put(attemptId, attemptInfo);
    }

    private void handleTaskFinishedEvent(TaskFinishedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        taskInfo.counters = event.getCounters();
        taskInfo.finishTime = event.getFinishTime();
        taskInfo.status = TaskStatus.State.SUCCEEDED.toString();
        taskInfo.successfulAttemptId = event.getSuccessfulTaskAttemptId();
    }

    private void handleTaskUpdatedEvent(TaskUpdatedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        taskInfo.finishTime = event.getFinishTime();
    }

    private void handleTaskFailedEvent(TaskFailedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        taskInfo.status = TaskStatus.State.FAILED.toString();
        taskInfo.finishTime = event.getFinishTime();
        taskInfo.error = StringInterner.weakIntern(event.getError());
        taskInfo.failedDueToAttemptId = event.getFailedAttemptID();
        taskInfo.counters = event.getCounters();
    }

    private void handleTaskStartedEvent(TaskStartedEvent event) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.taskId = event.getTaskId();
        taskInfo.startTime = event.getStartTime();
        taskInfo.taskType = event.getTaskType();
        taskInfo.splitLocations = event.getSplitLocations();
        this.info.tasksMap.put(event.getTaskId(), taskInfo);
    }

    private void handleJobFailedEvent(JobUnsuccessfulCompletionEvent event) {
        this.info.finishTime = event.getFinishTime();
        this.info.succeededMaps = event.getSucceededMaps();
        this.info.succeededReduces = event.getSucceededReduces();
        this.info.failedMaps = event.getFailedMaps();
        this.info.failedReduces = event.getFailedReduces();
        this.info.killedMaps = event.getKilledMaps();
        this.info.killedReduces = event.getKilledReduces();
        this.info.jobStatus = StringInterner.weakIntern(event.getStatus());
        this.info.errorInfo = StringInterner.weakIntern(event.getDiagnostics());
    }

    private void handleJobFinishedEvent(JobFinishedEvent event) {
        this.info.finishTime = event.getFinishTime();
        this.info.succeededMaps = event.getSucceededMaps();
        this.info.succeededReduces = event.getSucceededReduces();
        this.info.failedMaps = event.getFailedMaps();
        this.info.failedReduces = event.getFailedReduces();
        this.info.killedMaps = event.getKilledMaps();
        this.info.killedReduces = event.getKilledReduces();
        this.info.totalCounters = event.getTotalCounters();
        this.info.mapCounters = event.getMapCounters();
        this.info.reduceCounters = event.getReduceCounters();
        this.info.jobStatus = JobStatus.getJobRunState(JobStatus.SUCCEEDED);
    }

    private void handleJobPriorityChangeEvent(JobPriorityChangeEvent event) {
        this.info.priority = event.getPriority();
    }

    private void handleJobQueueChangeEvent(JobQueueChangeEvent event) {
        this.info.jobQueueName = event.getJobQueueName();
    }

    private void handleJobInitedEvent(JobInitedEvent event) {
        this.info.launchTime = event.getLaunchTime();
        this.info.totalMaps = event.getTotalMaps();
        this.info.totalReduces = event.getTotalReduces();
        this.info.uberized = event.getUberized();
    }

    private void handleAMStartedEvent(AMStartedEvent event) {
        AMInfo amInfo = new AMInfo();
        amInfo.appAttemptId = event.getAppAttemptId();
        amInfo.startTime = event.getStartTime();
        amInfo.containerId = event.getContainerId();
        amInfo.nodeManagerHost = StringInterner.weakIntern(event.getNodeManagerHost());
        amInfo.nodeManagerPort = event.getNodeManagerPort();
        amInfo.nodeManagerHttpPort = event.getNodeManagerHttpPort();
        if (this.info.amInfos == null) {
            this.info.amInfos = new LinkedList<AMInfo>();
        }
        this.info.amInfos.add(amInfo);
        this.info.latestAmInfo = amInfo;
    }

    private void handleJobInfoChangeEvent(JobInfoChangeEvent event) {
        this.info.submitTime = event.getSubmitTime();
        this.info.launchTime = event.getLaunchTime();
    }

    private void handleJobSubmittedEvent(JobSubmittedEvent event) {
        this.info.jobid = event.getJobId();
        this.info.jobname = event.getJobName();
        this.info.username = StringInterner.weakIntern(event.getUserName());
        this.info.submitTime = event.getSubmitTime();
        this.info.jobConfPath = event.getJobConfPath();
        this.info.jobACLs = event.getJobAcls();
        this.info.jobQueueName = StringInterner.weakIntern(event.getJobQueueName());
    }

    public static class AMInfo {
        ApplicationAttemptId appAttemptId;
        long startTime;
        ContainerId containerId;
        String nodeManagerHost;
        int nodeManagerPort;
        int nodeManagerHttpPort;

        public AMInfo() {
            this.startTime = -1L;
            this.nodeManagerHost = "";
            this.nodeManagerHttpPort = -1;
        }

        public AMInfo(ApplicationAttemptId appAttemptId, long startTime, ContainerId containerId, String nodeManagerHost, int nodeManagerPort, int nodeManagerHttpPort) {
            this.appAttemptId = appAttemptId;
            this.startTime = startTime;
            this.containerId = containerId;
            this.nodeManagerHost = nodeManagerHost;
            this.nodeManagerPort = nodeManagerPort;
            this.nodeManagerHttpPort = nodeManagerHttpPort;
        }

        public void printAll() {
            System.out.println("APPLICATION_ATTEMPT_ID:" + this.appAttemptId.toString());
            System.out.println("START_TIME: " + this.startTime);
            System.out.println("CONTAINER_ID: " + this.containerId.toString());
            System.out.println("NODE_MANAGER_HOST: " + this.nodeManagerHost);
            System.out.println("NODE_MANAGER_PORT: " + this.nodeManagerPort);
            System.out.println("NODE_MANAGER_HTTP_PORT: " + this.nodeManagerHttpPort);
        }

        public ApplicationAttemptId getAppAttemptId() {
            return this.appAttemptId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public String getNodeManagerHost() {
            return this.nodeManagerHost;
        }

        public int getNodeManagerPort() {
            return this.nodeManagerPort;
        }

        public int getNodeManagerHttpPort() {
            return this.nodeManagerHttpPort;
        }
    }

    public static class TaskAttemptInfo {
        TaskAttemptID attemptId;
        long startTime = -1L;
        long finishTime = -1L;
        long shuffleFinishTime = -1L;
        long sortFinishTime = -1L;
        long mapFinishTime = -1L;
        String error = "";
        String status;
        String state = "";
        TaskType taskType;
        String trackerName = "";
        Counters counters;
        int httpPort = -1;
        int shufflePort = -1;
        String hostname = "";
        int port = -1;
        String rackname = "";
        ContainerId containerId;

        public void printAll() {
            System.out.println("ATTEMPT_ID:" + this.attemptId.toString());
            System.out.println("START_TIME: " + this.startTime);
            System.out.println("FINISH_TIME:" + this.finishTime);
            System.out.println("ERROR:" + this.error);
            System.out.println("TASK_STATUS:" + this.status);
            System.out.println("STATE:" + this.state);
            System.out.println("TASK_TYPE:" + (Object)((Object)this.taskType));
            System.out.println("TRACKER_NAME:" + this.trackerName);
            System.out.println("HTTP_PORT:" + this.httpPort);
            System.out.println("SHUFFLE_PORT:" + this.shufflePort);
            System.out.println("CONTIANER_ID:" + this.containerId);
            if (this.counters != null) {
                System.out.println("COUNTERS:" + this.counters.toString());
            }
        }

        public TaskAttemptID getAttemptId() {
            return this.attemptId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public long getShuffleFinishTime() {
            return this.shuffleFinishTime;
        }

        public long getSortFinishTime() {
            return this.sortFinishTime;
        }

        public long getMapFinishTime() {
            return this.mapFinishTime;
        }

        public String getError() {
            return this.error;
        }

        public String getState() {
            return this.state;
        }

        public String getTaskStatus() {
            return this.status;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public String getTrackerName() {
            return this.trackerName;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public String getRackname() {
            return this.rackname;
        }

        public Counters getCounters() {
            return this.counters;
        }

        public int getHttpPort() {
            return this.httpPort;
        }

        public int getShufflePort() {
            return this.shufflePort;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }
    }

    public static class TaskInfo {
        TaskID taskId;
        long startTime = -1L;
        long finishTime = -1L;
        TaskType taskType;
        String splitLocations = "";
        Counters counters;
        String status;
        String error = "";
        TaskAttemptID failedDueToAttemptId;
        TaskAttemptID successfulAttemptId;
        Map<TaskAttemptID, TaskAttemptInfo> attemptsMap = new HashMap<TaskAttemptID, TaskAttemptInfo>();

        public void printAll() {
            System.out.println("TASK_ID:" + this.taskId.toString());
            System.out.println("START_TIME: " + this.startTime);
            System.out.println("FINISH_TIME:" + this.finishTime);
            System.out.println("TASK_TYPE:" + (Object)((Object)this.taskType));
            if (this.counters != null) {
                System.out.println("COUNTERS:" + this.counters.toString());
            }
            for (TaskAttemptInfo tinfo : this.attemptsMap.values()) {
                tinfo.printAll();
            }
        }

        public TaskID getTaskId() {
            return this.taskId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public String getSplitLocations() {
            return this.splitLocations;
        }

        public Counters getCounters() {
            return this.counters;
        }

        public String getTaskStatus() {
            return this.status;
        }

        public TaskAttemptID getFailedDueToAttemptId() {
            return this.failedDueToAttemptId;
        }

        public TaskAttemptID getSuccessfulAttemptId() {
            return this.successfulAttemptId;
        }

        public String getError() {
            return this.error;
        }

        public Map<TaskAttemptID, TaskAttemptInfo> getAllTaskAttempts() {
            return this.attemptsMap;
        }
    }

    public static class JobInfo {
        String errorInfo = "";
        long submitTime = -1L;
        long finishTime = -1L;
        JobID jobid;
        String username = "";
        String jobname = "";
        String jobQueueName = "";
        String jobConfPath = "";
        long launchTime = -1L;
        int totalMaps = 0;
        int totalReduces = 0;
        int failedMaps = 0;
        int failedReduces = 0;
        int succeededMaps = 0;
        int succeededReduces = 0;
        int killedMaps;
        int killedReduces;
        String jobStatus;
        Counters totalCounters;
        Counters mapCounters;
        Counters reduceCounters;
        JobPriority priority;
        Map<JobACL, AccessControlList> jobACLs;
        Map<TaskID, TaskInfo> tasksMap = new HashMap<TaskID, TaskInfo>();
        Map<TaskAttemptID, TaskAttemptInfo> completedTaskAttemptsMap = new HashMap<TaskAttemptID, TaskAttemptInfo>();
        List<AMInfo> amInfos;
        AMInfo latestAmInfo;
        boolean uberized;

        public JobInfo() {
            this.jobACLs = new HashMap<JobACL, AccessControlList>();
            this.priority = JobPriority.NORMAL;
        }

        public void printAll() {
            System.out.println("JOBNAME: " + this.jobname);
            System.out.println("USERNAME: " + this.username);
            System.out.println("JOB_QUEUE_NAME: " + this.jobQueueName);
            System.out.println("SUBMIT_TIME" + this.submitTime);
            System.out.println("LAUNCH_TIME: " + this.launchTime);
            System.out.println("JOB_STATUS: " + this.jobStatus);
            System.out.println("PRIORITY: " + (Object)((Object)this.priority));
            System.out.println("TOTAL_MAPS: " + this.totalMaps);
            System.out.println("TOTAL_REDUCES: " + this.totalReduces);
            if (this.mapCounters != null) {
                System.out.println("MAP_COUNTERS:" + this.mapCounters.toString());
            }
            if (this.reduceCounters != null) {
                System.out.println("REDUCE_COUNTERS:" + this.reduceCounters.toString());
            }
            if (this.totalCounters != null) {
                System.out.println("TOTAL_COUNTERS: " + this.totalCounters.toString());
            }
            System.out.println("UBERIZED: " + this.uberized);
            if (this.amInfos != null) {
                for (AMInfo amInfo : this.amInfos) {
                    amInfo.printAll();
                }
            }
            for (TaskInfo ti : this.tasksMap.values()) {
                ti.printAll();
            }
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public JobID getJobId() {
            return this.jobid;
        }

        public String getUsername() {
            return this.username;
        }

        public String getJobname() {
            return this.jobname;
        }

        public String getJobQueueName() {
            return this.jobQueueName;
        }

        public String getJobConfPath() {
            return this.jobConfPath;
        }

        public long getLaunchTime() {
            return this.launchTime;
        }

        public long getTotalMaps() {
            return this.totalMaps;
        }

        public long getTotalReduces() {
            return this.totalReduces;
        }

        public long getFailedMaps() {
            return this.failedMaps;
        }

        public long getFailedReduces() {
            return this.failedReduces;
        }

        public long getKilledMaps() {
            return this.killedMaps;
        }

        public long getKilledReduces() {
            return this.killedReduces;
        }

        public long getSucceededMaps() {
            return this.succeededMaps;
        }

        public long getSucceededReduces() {
            return this.succeededReduces;
        }

        public String getJobStatus() {
            return this.jobStatus;
        }

        public String getErrorInfo() {
            return this.errorInfo;
        }

        public Counters getTotalCounters() {
            return this.totalCounters;
        }

        public Counters getMapCounters() {
            return this.mapCounters;
        }

        public Counters getReduceCounters() {
            return this.reduceCounters;
        }

        public Map<TaskID, TaskInfo> getAllTasks() {
            return this.tasksMap;
        }

        public Map<TaskAttemptID, TaskAttemptInfo> getAllCompletedTaskAttempts() {
            return this.completedTaskAttemptsMap;
        }

        public String getPriority() {
            return this.priority.toString();
        }

        public Map<JobACL, AccessControlList> getJobACLs() {
            return this.jobACLs;
        }

        public boolean getUberized() {
            return this.uberized;
        }

        public List<AMInfo> getAMInfos() {
            return this.amInfos;
        }

        public AMInfo getLatestAMInfo() {
            return this.latestAmInfo;
        }
    }
}

