/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.prestosql.hadoop.$internal.org.apache.avro.util.Utf8;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.ProgressSplitsBlock;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.AvroArrayUtils;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinished;
import org.apache.hadoop.mapreduce.util.JobHistoryEventUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.util.SystemClock;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ReduceAttemptFinishedEvent
implements HistoryEvent {
    private ReduceAttemptFinished datum = null;
    private TaskAttemptID attemptId;
    private TaskType taskType;
    private String taskStatus;
    private long shuffleFinishTime;
    private long sortFinishTime;
    private long finishTime;
    private String hostname;
    private String rackName;
    private int port;
    private String state;
    private Counters counters;
    int[][] allSplits;
    int[] clockSplits;
    int[] cpuUsages;
    int[] vMemKbytes;
    int[] physMemKbytes;
    private long startTime;

    public ReduceAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long shuffleFinishTime, long sortFinishTime, long finishTime, String hostname, int port, String rackName, String state, Counters counters, int[][] allSplits, long startTs) {
        this.attemptId = id;
        this.taskType = taskType;
        this.taskStatus = taskStatus;
        this.shuffleFinishTime = shuffleFinishTime;
        this.sortFinishTime = sortFinishTime;
        this.finishTime = finishTime;
        this.hostname = hostname;
        this.rackName = rackName;
        this.port = port;
        this.state = state;
        this.counters = counters;
        this.allSplits = allSplits;
        this.clockSplits = ProgressSplitsBlock.arrayGetWallclockTime(allSplits);
        this.cpuUsages = ProgressSplitsBlock.arrayGetCPUTime(allSplits);
        this.vMemKbytes = ProgressSplitsBlock.arrayGetVMemKbytes(allSplits);
        this.physMemKbytes = ProgressSplitsBlock.arrayGetPhysMemKbytes(allSplits);
        this.startTime = startTs;
    }

    public ReduceAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long shuffleFinishTime, long sortFinishTime, long finishTime, String hostname, int port, String rackName, String state, Counters counters, int[][] allSplits) {
        this(id, taskType, taskStatus, shuffleFinishTime, sortFinishTime, finishTime, hostname, port, rackName, state, counters, allSplits, SystemClock.getInstance().getTime());
    }

    public ReduceAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long shuffleFinishTime, long sortFinishTime, long finishTime, String hostname, String state, Counters counters) {
        this(id, taskType, taskStatus, shuffleFinishTime, sortFinishTime, finishTime, hostname, -1, "", state, counters, null);
    }

    ReduceAttemptFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new ReduceAttemptFinished();
            this.datum.setTaskid(new Utf8(this.attemptId.getTaskID().toString()));
            this.datum.setAttemptId(new Utf8(this.attemptId.toString()));
            this.datum.setTaskType(new Utf8(this.taskType.name()));
            this.datum.setTaskStatus(new Utf8(this.taskStatus));
            this.datum.setShuffleFinishTime(this.shuffleFinishTime);
            this.datum.setSortFinishTime(this.sortFinishTime);
            this.datum.setFinishTime(this.finishTime);
            this.datum.setHostname(new Utf8(this.hostname));
            this.datum.setPort(this.port);
            if (this.rackName != null) {
                this.datum.setRackname(new Utf8(this.rackName));
            }
            this.datum.setState(new Utf8(this.state));
            this.datum.setCounters(EventWriter.toAvro(this.counters));
            this.datum.setClockSplits(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetWallclockTime(this.allSplits)));
            this.datum.setCpuUsages(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetCPUTime(this.allSplits)));
            this.datum.setVMemKbytes(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetVMemKbytes(this.allSplits)));
            this.datum.setPhysMemKbytes(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetPhysMemKbytes(this.allSplits)));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object oDatum) {
        this.datum = (ReduceAttemptFinished)oDatum;
        this.attemptId = TaskAttemptID.forName(this.datum.getAttemptId().toString());
        this.taskType = TaskType.valueOf(this.datum.getTaskType().toString());
        this.taskStatus = this.datum.getTaskStatus().toString();
        this.shuffleFinishTime = this.datum.getShuffleFinishTime();
        this.sortFinishTime = this.datum.getSortFinishTime();
        this.finishTime = this.datum.getFinishTime();
        this.hostname = this.datum.getHostname().toString();
        this.rackName = this.datum.getRackname().toString();
        this.port = this.datum.getPort();
        this.state = this.datum.getState().toString();
        this.counters = EventReader.fromAvro(this.datum.getCounters());
        this.clockSplits = AvroArrayUtils.fromAvro(this.datum.getClockSplits());
        this.cpuUsages = AvroArrayUtils.fromAvro(this.datum.getCpuUsages());
        this.vMemKbytes = AvroArrayUtils.fromAvro(this.datum.getVMemKbytes());
        this.physMemKbytes = AvroArrayUtils.fromAvro(this.datum.getPhysMemKbytes());
    }

    public TaskID getTaskId() {
        return this.attemptId.getTaskID();
    }

    public TaskAttemptID getAttemptId() {
        return this.attemptId;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getTaskStatus() {
        return this.taskStatus.toString();
    }

    public long getSortFinishTime() {
        return this.sortFinishTime;
    }

    public long getShuffleFinishTime() {
        return this.shuffleFinishTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getHostname() {
        return this.hostname.toString();
    }

    public int getPort() {
        return this.port;
    }

    public String getRackName() {
        return this.rackName == null ? null : this.rackName.toString();
    }

    public String getState() {
        return this.state.toString();
    }

    Counters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        return EventType.REDUCE_ATTEMPT_FINISHED;
    }

    public int[] getClockSplits() {
        return this.clockSplits;
    }

    public int[] getCpuUsages() {
        return this.cpuUsages;
    }

    public int[] getVMemKbytes() {
        return this.vMemKbytes;
    }

    public int[] getPhysMemKbytes() {
        return this.physMemKbytes;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("TASK_TYPE", (Object)this.getTaskType().toString());
        tEvent.addInfo("ATTEMPT_ID", (Object)(this.getAttemptId() == null ? "" : this.getAttemptId().toString()));
        tEvent.addInfo("FINISH_TIME", (Object)this.getFinishTime());
        tEvent.addInfo("STATUS", (Object)this.getTaskStatus());
        tEvent.addInfo("STATE", (Object)this.getState());
        tEvent.addInfo("SHUFFLE_FINISH_TIME", (Object)this.getShuffleFinishTime());
        tEvent.addInfo("SORT_FINISH_TIME", (Object)this.getSortFinishTime());
        tEvent.addInfo("HOSTNAME", (Object)this.getHostname());
        tEvent.addInfo("PORT", (Object)this.getPort());
        tEvent.addInfo("RACK_NAME", (Object)this.getRackName());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        Set<TimelineMetric> metrics = JobHistoryEventUtils.countersToTimelineMetric(this.getCounters(), this.finishTime);
        return metrics;
    }
}

