/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.http;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.org.apache.commons.lang3.StringUtils;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CrossOriginFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CrossOriginFilter.class);
    static final String ORIGIN = "Origin";
    static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ALLOWED_ORIGINS = "allowed-origins";
    public static final String ALLOWED_ORIGINS_DEFAULT = "*";
    public static final String ALLOWED_ORIGINS_REGEX_PREFIX = "regex:";
    public static final String ALLOWED_METHODS = "allowed-methods";
    public static final String ALLOWED_METHODS_DEFAULT = "GET,POST,HEAD";
    public static final String ALLOWED_HEADERS = "allowed-headers";
    public static final String ALLOWED_HEADERS_DEFAULT = "X-Requested-With,Content-Type,Accept,Origin";
    public static final String MAX_AGE = "max-age";
    public static final String MAX_AGE_DEFAULT = "1800";
    private List<String> allowedMethods = new ArrayList<String>();
    private List<String> allowedHeaders = new ArrayList<String>();
    private List<String> allowedOrigins = new ArrayList<String>();
    private boolean allowAllOrigins = true;
    private String maxAge;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initializeAllowedMethods(filterConfig);
        this.initializeAllowedHeaders(filterConfig);
        this.initializeAllowedOrigins(filterConfig);
        this.initializeMaxAge(filterConfig);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.doCrossFilter((HttpServletRequest)req, (HttpServletResponse)res);
        chain.doFilter(req, res);
    }

    public void destroy() {
        this.allowedMethods.clear();
        this.allowedHeaders.clear();
        this.allowedOrigins.clear();
    }

    private void doCrossFilter(HttpServletRequest req, HttpServletResponse res) {
        String originsList = CrossOriginFilter.encodeHeader(req.getHeader(ORIGIN));
        if (!CrossOriginFilter.isCrossOrigin(originsList)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Header origin is null. Returning");
            }
            return;
        }
        if (!this.areOriginsAllowed(originsList)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Header origins '" + originsList + "' not allowed. Returning");
            }
            return;
        }
        String accessControlRequestMethod = req.getHeader(ACCESS_CONTROL_REQUEST_METHOD);
        if (!this.isMethodAllowed(accessControlRequestMethod)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Access control method '" + accessControlRequestMethod + "' not allowed. Returning");
            }
            return;
        }
        String accessControlRequestHeaders = req.getHeader(ACCESS_CONTROL_REQUEST_HEADERS);
        if (!this.areHeadersAllowed(accessControlRequestHeaders)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Access control headers '" + accessControlRequestHeaders + "' not allowed. Returning");
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Completed cross origin filter checks. Populating HttpServletResponse");
        }
        res.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, originsList);
        res.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, Boolean.TRUE.toString());
        res.setHeader(ACCESS_CONTROL_ALLOW_METHODS, this.getAllowedMethodsHeader());
        res.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, this.getAllowedHeadersHeader());
        res.setHeader(ACCESS_CONTROL_MAX_AGE, this.maxAge);
    }

    @.VisibleForTesting
    String getAllowedHeadersHeader() {
        return StringUtils.join(this.allowedHeaders, ',');
    }

    @.VisibleForTesting
    String getAllowedMethodsHeader() {
        return StringUtils.join(this.allowedMethods, ',');
    }

    private void initializeAllowedMethods(FilterConfig filterConfig) {
        String allowedMethodsConfig = filterConfig.getInitParameter(ALLOWED_METHODS);
        if (allowedMethodsConfig == null) {
            allowedMethodsConfig = ALLOWED_METHODS_DEFAULT;
        }
        this.allowedMethods.addAll(Arrays.asList(allowedMethodsConfig.trim().split("\\s*,\\s*")));
        LOG.info("Allowed Methods: " + this.getAllowedMethodsHeader());
    }

    private void initializeAllowedHeaders(FilterConfig filterConfig) {
        String allowedHeadersConfig = filterConfig.getInitParameter(ALLOWED_HEADERS);
        if (allowedHeadersConfig == null) {
            allowedHeadersConfig = ALLOWED_HEADERS_DEFAULT;
        }
        this.allowedHeaders.addAll(Arrays.asList(allowedHeadersConfig.trim().split("\\s*,\\s*")));
        LOG.info("Allowed Headers: " + this.getAllowedHeadersHeader());
    }

    private void initializeAllowedOrigins(FilterConfig filterConfig) {
        String allowedOriginsConfig = filterConfig.getInitParameter(ALLOWED_ORIGINS);
        if (allowedOriginsConfig == null) {
            allowedOriginsConfig = ALLOWED_ORIGINS_DEFAULT;
        }
        this.allowedOrigins.addAll(Arrays.asList(allowedOriginsConfig.trim().split("\\s*,\\s*")));
        this.allowAllOrigins = this.allowedOrigins.contains(ALLOWED_ORIGINS_DEFAULT);
        LOG.info("Allowed Origins: " + StringUtils.join(this.allowedOrigins, ','));
        LOG.info("Allow All Origins: " + this.allowAllOrigins);
        List discouragedAllowedOrigins = this.allowedOrigins.stream().filter(s -> s.length() > 1 && s.contains(ALLOWED_ORIGINS_DEFAULT)).collect(Collectors.toList());
        for (String discouragedAllowedOrigin : discouragedAllowedOrigins) {
            LOG.warn("Allowed Origin pattern '" + discouragedAllowedOrigin + "' is discouraged, use the 'regex:' prefix and use a Java regular expression instead.");
        }
    }

    private void initializeMaxAge(FilterConfig filterConfig) {
        this.maxAge = filterConfig.getInitParameter(MAX_AGE);
        if (this.maxAge == null) {
            this.maxAge = MAX_AGE_DEFAULT;
        }
        LOG.info("Max Age: " + this.maxAge);
    }

    static String encodeHeader(String header) {
        if (header == null) {
            return null;
        }
        return header.split("\n|\r")[0].trim();
    }

    static boolean isCrossOrigin(String originsList) {
        return originsList != null;
    }

    @.VisibleForTesting
    boolean areOriginsAllowed(String originsList) {
        String[] origins;
        if (this.allowAllOrigins) {
            return true;
        }
        for (String origin : origins = originsList.trim().split("\\s+")) {
            for (String allowedOrigin : this.allowedOrigins) {
                String regex;
                Pattern regexPattern = null;
                if (allowedOrigin.startsWith(ALLOWED_ORIGINS_REGEX_PREFIX)) {
                    regex = allowedOrigin.substring(ALLOWED_ORIGINS_REGEX_PREFIX.length());
                    regexPattern = Pattern.compile(regex);
                } else if (allowedOrigin.contains(ALLOWED_ORIGINS_DEFAULT)) {
                    regex = allowedOrigin.replace(".", "\\.").replace(ALLOWED_ORIGINS_DEFAULT, ".*");
                    regexPattern = Pattern.compile(regex);
                }
                if (regexPattern != null && regexPattern.matcher(origin).matches()) {
                    return true;
                }
                if (!allowedOrigin.equals(origin)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areHeadersAllowed(String accessControlRequestHeaders) {
        if (accessControlRequestHeaders == null) {
            return true;
        }
        String[] headers = accessControlRequestHeaders.trim().split("\\s*,\\s*");
        return this.allowedHeaders.containsAll(Arrays.asList(headers));
    }

    private boolean isMethodAllowed(String accessControlRequestMethod) {
        if (accessControlRequestMethod == null) {
            return true;
        }
        return this.allowedMethods.contains(accessControlRequestMethod);
    }
}

