/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class NativeCodeLoader {
    private static final Logger LOG;
    private static boolean nativeCodeLoaded;

    private NativeCodeLoader() {
    }

    public static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    public static native boolean buildSupportsSnappy();

    public static native boolean buildSupportsIsal();

    public static native boolean buildSupportsZstd();

    public static native boolean buildSupportsOpenssl();

    public static native String getLibraryName();

    static {
        block4: {
            LOG = LoggerFactory.getLogger(NativeCodeLoader.class);
            nativeCodeLoaded = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to load the custom-built native-hadoop library...");
            }
            try {
                System.loadLibrary("hadoop");
                LOG.debug("Loaded the native-hadoop library");
                nativeCodeLoaded = true;
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Failed to load native-hadoop with error: " + t);
                LOG.debug("java.library.path=" + System.getProperty("java.library.path"));
            }
        }
        if (!nativeCodeLoaded) {
            LOG.warn("Unable to load native-hadoop library for your platform... using builtin-java classes where applicable");
        }
    }
}

