/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core;

import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonGenerator;
import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonParseException;
import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonParser;
import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonToken;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.EncryptionAlgorithm;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.JsonUtilities;
import java.io.IOException;

public class EncryptionAgent {
    public EncryptionAlgorithm encryptionAlgorithm;
    public String protocol;

    public EncryptionAgent() {
    }

    public EncryptionAgent(String protocol, EncryptionAlgorithm algorithm) {
        this.protocol = protocol;
        this.encryptionAlgorithm = algorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeStringField("Protocol", this.getProtocol());
        generator.writeStringField("EncryptionAlgorithm", this.getEncryptionAlgorithm().toString());
    }

    public static EncryptionAgent deserialize(JsonParser parser) throws JsonParseException, IOException {
        JsonUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        EncryptionAgent agent = new EncryptionAgent();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String name = parser.getCurrentName();
            parser.nextToken();
            if (name.equals("Protocol")) {
                agent.setProtocol(parser.getValueAsString());
            } else if (name.equals("EncryptionAlgorithm")) {
                agent.setEncryptionAlgorithm(EncryptionAlgorithm.valueOf(parser.getValueAsString()));
            }
            parser.nextToken();
        }
        JsonUtilities.assertIsEndObjectJsonToken(parser);
        return agent;
    }
}

