/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc.provider;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc.provider.AbstractEncryptProvider;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DesProvider
extends AbstractEncryptProvider {
    public DesProvider() {
        super(8, 7, 8);
    }

    @Override
    protected void doEncrypt(byte[] input, byte[] key, byte[] cipherState, boolean encrypt) throws KrbException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (GeneralSecurityException e) {
            throw new KrbException("Failed to init cipher", (Throwable)e);
        }
        IvParameterSpec params = new IvParameterSpec(cipherState);
        SecretKeySpec skSpec = new SecretKeySpec(key, "DES");
        try {
            cipher.init(encrypt ? 1 : 2, (Key)skSpec, params);
            byte[] output = cipher.doFinal(input);
            System.arraycopy(output, 0, input, 0, output.length);
        }
        catch (GeneralSecurityException e) {
            KrbException ke = new KrbException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    @Override
    public byte[] cbcMac(byte[] key, byte[] cipherState, byte[] data) throws KrbException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (GeneralSecurityException e) {
            throw new KrbException("Failed to init cipher", (Throwable)e);
        }
        IvParameterSpec params = new IvParameterSpec(cipherState);
        SecretKeySpec skSpec = new SecretKeySpec(key, "DES");
        byte[] output = null;
        try {
            cipher.init(1, (Key)skSpec, params);
            for (int i = 0; i < data.length / 8; ++i) {
                output = cipher.doFinal(data, i * 8, 8);
                cipher.init(1, (Key)skSpec, new IvParameterSpec(output));
            }
        }
        catch (GeneralSecurityException e) {
            KrbException ke = new KrbException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
        return output;
    }

    @Override
    public boolean supportCbcMac() {
        return true;
    }
}

