/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.request;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbCodec;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbErrorCode;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcContext;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.request.ServiceTicketIssuer;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ap.ApOption;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ap.Authenticator;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KrbMessageType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.LastReq;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.LastReqEntry;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.LastReqType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.EncKdcRepPart;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.EncTgsRepPart;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.TgsRep;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.TgsReq;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ticket.EncTicketPart;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ticket.TicketFlag;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.nio.ByteBuffer;

public class TgsRequest
extends KdcRequest {
    private static final Logger LOG = LoggerFactory.getLogger(TgsRequest.class);
    private EncryptionKey tgtSessionKey;
    private Ticket tgtTicket;

    public TgsRequest(TgsReq tgsReq, KdcContext kdcContext) {
        super(tgsReq, kdcContext);
        this.setPreauthRequired(true);
    }

    public EncryptionKey getTgtSessionKey() {
        return this.tgtSessionKey;
    }

    public void setTgtSessionKey(EncryptionKey tgtSessionKey) {
        this.tgtSessionKey = tgtSessionKey;
    }

    @Override
    protected void checkClient() throws KrbException {
    }

    public Ticket getTgtTicket() {
        return this.tgtTicket;
    }

    @Override
    protected void issueTicket() throws KrbException {
        ServiceTicketIssuer issuer = new ServiceTicketIssuer(this);
        Ticket newTicket = issuer.issueTicket();
        LOG.info("TGS_REQ ISSUE: authtime " + newTicket.getEncPart().getAuthTime().getTime() + "," + newTicket.getEncPart().getCname() + " for " + newTicket.getSname());
        this.setTicket(newTicket);
    }

    public void verifyAuthenticator(PaDataEntry paDataEntry) throws KrbException {
        ApReq apReq = KrbCodec.decode(paDataEntry.getPaDataValue(), ApReq.class);
        if (apReq.getPvno() != 5) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADVERSION);
        }
        if (apReq.getMsgType() != KrbMessageType.AP_REQ) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_MSG_TYPE);
        }
        this.tgtTicket = apReq.getTicket();
        EncryptionType encType = this.tgtTicket.getEncryptedEncPart().getEType();
        EncryptionKey tgsKey = this.getTgsEntry().getKeys().get(encType);
        if (this.tgtTicket.getTktvno() != 5) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADVERSION);
        }
        EncTicketPart encPart = EncryptionUtil.unseal(this.tgtTicket.getEncryptedEncPart(), tgsKey, KeyUsage.KDC_REP_TICKET, EncTicketPart.class);
        this.tgtTicket.setEncPart(encPart);
        EncryptionKey encKey = null;
        encKey = this.tgtTicket.getEncPart().getKey();
        if (encKey == null) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_NOKEY);
        }
        Authenticator authenticator = EncryptionUtil.unseal(apReq.getEncryptedAuthenticator(), encKey, KeyUsage.TGS_REQ_AUTH, Authenticator.class);
        if (!authenticator.getCname().equals(this.tgtTicket.getEncPart().getCname())) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADMATCH);
        }
        HostAddresses hostAddresses = this.tgtTicket.getEncPart().getClientAddresses();
        if (hostAddresses == null || hostAddresses.isEmpty() ? !this.getKdcContext().getConfig().isEmptyAddressesAllowed() : !hostAddresses.contains(this.getClientAddress())) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADADDR);
        }
        PrincipalName serverPrincipal = this.tgtTicket.getSname();
        serverPrincipal.setRealm(this.tgtTicket.getRealm());
        PrincipalName clientPrincipal = authenticator.getCname();
        clientPrincipal.setRealm(authenticator.getCrealm());
        KrbIdentity clientEntry = this.getEntry(clientPrincipal.getName());
        this.setClientEntry(clientEntry);
        if (!authenticator.getCtime().isInClockSkew(this.getKdcContext().getConfig().getAllowableClockSkew() * 1000L)) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_SKEW);
        }
        KerberosTime now = KerberosTime.now();
        KerberosTime startTime = this.tgtTicket.getEncPart().getStartTime();
        if (startTime == null) {
            startTime = this.tgtTicket.getEncPart().getAuthTime();
        }
        if (!startTime.lessThan(now)) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_TKT_NYV);
        }
        KerberosTime endTime = this.tgtTicket.getEncPart().getEndTime();
        if (!endTime.greaterThan(now)) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_TKT_EXPIRED);
        }
        apReq.getApOptions().setFlag(ApOption.MUTUAL_REQUIRED);
        this.setTgtSessionKey(this.tgtTicket.getEncPart().getKey());
    }

    @Override
    protected void makeReply() throws KrbException {
        Ticket ticket = this.getTicket();
        TgsRep reply = new TgsRep();
        if (this.getClientEntry() == null) {
            reply.setCname(ticket.getEncPart().getCname());
        } else {
            reply.setCname(this.getClientEntry().getPrincipal());
        }
        reply.setCrealm(this.getKdcContext().getKdcRealm());
        reply.setTicket(ticket);
        EncKdcRepPart encKdcRepPart = this.makeEncKdcRepPart();
        reply.setEncPart(encKdcRepPart);
        EncryptionKey sessionKey = this.getToken() != null ? this.getSessionKey() : this.getTgtSessionKey();
        EncryptedData encryptedData = EncryptionUtil.seal(encKdcRepPart, sessionKey, KeyUsage.TGS_REP_ENCPART_SESSKEY);
        reply.setEncryptedEncPart(encryptedData);
        this.setReply(reply);
    }

    private EncKdcRepPart makeEncKdcRepPart() {
        KdcReq request = this.getKdcReq();
        Ticket ticket = this.getTicket();
        EncTgsRepPart encKdcRepPart = new EncTgsRepPart();
        encKdcRepPart.setKey(ticket.getEncPart().getKey());
        LastReq lastReq = new LastReq();
        LastReqEntry entry = new LastReqEntry();
        entry.setLrType(LastReqType.THE_LAST_INITIAL);
        entry.setLrValue(new KerberosTime());
        lastReq.add(entry);
        encKdcRepPart.setLastReq(lastReq);
        encKdcRepPart.setNonce(request.getReqBody().getNonce());
        encKdcRepPart.setFlags(ticket.getEncPart().getFlags());
        encKdcRepPart.setAuthTime(ticket.getEncPart().getAuthTime());
        encKdcRepPart.setStartTime(ticket.getEncPart().getStartTime());
        encKdcRepPart.setEndTime(ticket.getEncPart().getEndTime());
        if (ticket.getEncPart().getFlags().isFlagSet(TicketFlag.RENEWABLE)) {
            encKdcRepPart.setRenewTill(ticket.getEncPart().getRenewtill());
        }
        encKdcRepPart.setSname(ticket.getSname());
        encKdcRepPart.setSrealm(ticket.getRealm());
        encKdcRepPart.setCaddr(ticket.getEncPart().getClientAddresses());
        return encKdcRepPart;
    }

    @Override
    public ByteBuffer getRequestBody() throws KrbException {
        return null;
    }
}

