/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.Asn1FieldInfo;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.EnumType;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.ExplicitField;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Integer;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1OctetString;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import java.util.Arrays;

public class EncryptedData
extends KrbSequenceType {
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField(EncryptedDataField.ETYPE, Asn1Integer.class), new ExplicitField(EncryptedDataField.KVNO, Asn1Integer.class), new ExplicitField(EncryptedDataField.CIPHER, Asn1OctetString.class)};

    public EncryptedData() {
        super(fieldInfos);
    }

    public EncryptionType getEType() {
        Integer value = this.getFieldAsInteger(EncryptedDataField.ETYPE);
        return EncryptionType.fromValue(value);
    }

    public void setEType(EncryptionType eType) {
        this.setFieldAsInt((EnumType)EncryptedDataField.ETYPE, eType.getValue());
    }

    public int getKvno() {
        Integer value = this.getFieldAsInteger(EncryptedDataField.KVNO);
        if (value != null) {
            return value;
        }
        return -1;
    }

    public void setKvno(int kvno) {
        this.setFieldAsInt((EnumType)EncryptedDataField.KVNO, kvno);
    }

    public byte[] getCipher() {
        return this.getFieldAsOctets(EncryptedDataField.CIPHER);
    }

    public void setCipher(byte[] cipher) {
        this.setFieldAsOctets(EncryptedDataField.CIPHER, cipher);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptedData)) {
            return false;
        }
        EncryptedData that = (EncryptedData)o;
        return this.getEType() == that.getEType() && Arrays.equals(this.getCipher(), that.getCipher());
    }

    public int hashCode() {
        int result = 17;
        if (this.getEType() != null) {
            result = 31 * result + this.getEType().hashCode();
        }
        if (this.getCipher() != null) {
            result = 31 * result + Arrays.hashCode(this.getCipher());
        }
        return result;
    }

    protected static enum EncryptedDataField implements EnumType
    {
        ETYPE,
        KVNO,
        CIPHER;


        @Override
        public int getValue() {
            return this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

