/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.xdr.type;

import io.prestosql.hadoop.$internal.org.apache.kerby.xdr.XdrDataType;
import io.prestosql.hadoop.$internal.org.apache.kerby.xdr.type.XdrType;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractXdrType<T>
implements XdrType {
    private XdrDataType dataType;
    private T value;

    public AbstractXdrType(XdrDataType dataType, T value) {
        this(dataType);
        this.value = value;
    }

    public AbstractXdrType(XdrDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public byte[] encode() throws IOException {
        int len = this.encodingLength();
        ByteBuffer byteBuffer = ByteBuffer.allocate(len);
        this.encode(byteBuffer);
        byteBuffer.flip();
        return byteBuffer.array();
    }

    @Override
    public void encode(ByteBuffer buffer) throws IOException {
        this.encodeBody(buffer);
    }

    protected abstract void encodeBody(ByteBuffer var1) throws IOException;

    @Override
    public void decode(byte[] content) throws IOException {
        this.decode(ByteBuffer.wrap(content));
    }

    @Override
    public int encodingLength() throws IOException {
        return this.encodingBodyLength();
    }

    protected abstract int encodingBodyLength() throws IOException;

    @Override
    public void decode(ByteBuffer content) throws IOException {
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public XdrDataType getDataType() {
        return this.dataType;
    }
}

