/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.GeneralSecurityException;
import java.util.EnumSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoStreamUtils;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.HasEnhancedByteBufferAccess;
import org.apache.hadoop.fs.HasFileDescriptor;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.StreamCapabilitiesPolicy;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CryptoInputStream
extends FilterInputStream
implements Seekable,
PositionedReadable,
ByteBufferReadable,
HasFileDescriptor,
CanSetDropBehind,
CanSetReadahead,
HasEnhancedByteBufferAccess,
ReadableByteChannel,
CanUnbuffer,
StreamCapabilities {
    private final byte[] oneByteBuf = new byte[1];
    private final CryptoCodec codec;
    private final Decryptor decryptor;
    private final int bufferSize;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer;
    private long streamOffset = 0L;
    private Boolean usingByteBufferRead = null;
    private byte padding;
    private boolean closed;
    private final byte[] key;
    private final byte[] initIV;
    private byte[] iv;
    private final boolean isByteBufferReadable;
    private final boolean isReadableByteChannel;
    private final Queue<ByteBuffer> bufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
    private final Queue<Decryptor> decryptorPool = new ConcurrentLinkedQueue<Decryptor>();
    private byte[] tmpBuf;

    public CryptoInputStream(InputStream in, CryptoCodec codec, int bufferSize, byte[] key, byte[] iv) throws IOException {
        this(in, codec, bufferSize, key, iv, CryptoStreamUtils.getInputStreamOffset(in));
    }

    public CryptoInputStream(InputStream in, CryptoCodec codec, int bufferSize, byte[] key, byte[] iv, long streamOffset) throws IOException {
        super(in);
        CryptoStreamUtils.checkCodec(codec);
        this.bufferSize = CryptoStreamUtils.checkBufferSize(codec, bufferSize);
        this.codec = codec;
        this.key = (byte[])key.clone();
        this.initIV = (byte[])iv.clone();
        this.iv = (byte[])iv.clone();
        this.streamOffset = streamOffset;
        this.isByteBufferReadable = in instanceof ByteBufferReadable;
        this.isReadableByteChannel = in instanceof ReadableByteChannel;
        this.inBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        this.outBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        this.decryptor = this.getDecryptor();
        this.resetStreamOffset(streamOffset);
    }

    public CryptoInputStream(InputStream in, CryptoCodec codec, byte[] key, byte[] iv) throws IOException {
        this(in, codec, CryptoStreamUtils.getBufferSize(codec.getConf()), key, iv);
    }

    public InputStream getWrappedStream() {
        return this.in;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int remaining = this.outBuffer.remaining();
        if (remaining > 0) {
            int n = Math.min(len, remaining);
            this.outBuffer.get(b, off, n);
            return n;
        }
        int n = 0;
        if (this.usingByteBufferRead == null) {
            if (this.isByteBufferReadable || this.isReadableByteChannel) {
                try {
                    n = this.isByteBufferReadable ? ((ByteBufferReadable)((Object)this.in)).read(this.inBuffer) : ((ReadableByteChannel)((Object)this.in)).read(this.inBuffer);
                    this.usingByteBufferRead = Boolean.TRUE;
                }
                catch (UnsupportedOperationException e) {
                    this.usingByteBufferRead = Boolean.FALSE;
                }
            } else {
                this.usingByteBufferRead = Boolean.FALSE;
            }
            if (!this.usingByteBufferRead.booleanValue()) {
                n = this.readFromUnderlyingStream(this.inBuffer);
            }
        } else {
            n = this.usingByteBufferRead != false ? (this.isByteBufferReadable ? ((ByteBufferReadable)((Object)this.in)).read(this.inBuffer) : ((ReadableByteChannel)((Object)this.in)).read(this.inBuffer)) : this.readFromUnderlyingStream(this.inBuffer);
        }
        if (n <= 0) {
            return n;
        }
        this.streamOffset += (long)n;
        this.decrypt(this.decryptor, this.inBuffer, this.outBuffer, this.padding);
        this.padding = this.afterDecryption(this.decryptor, this.inBuffer, this.streamOffset, this.iv);
        n = Math.min(len, this.outBuffer.remaining());
        this.outBuffer.get(b, off, n);
        return n;
    }

    private int readFromUnderlyingStream(ByteBuffer inBuffer) throws IOException {
        int toRead = inBuffer.remaining();
        byte[] tmp = this.getTmpBuf();
        int n = this.in.read(tmp, 0, toRead);
        if (n > 0) {
            inBuffer.put(tmp, 0, n);
        }
        return n;
    }

    private byte[] getTmpBuf() {
        if (this.tmpBuf == null) {
            this.tmpBuf = new byte[this.bufferSize];
        }
        return this.tmpBuf;
    }

    private void decrypt(Decryptor decryptor, ByteBuffer inBuffer, ByteBuffer outBuffer, byte padding) throws IOException {
        Preconditions.checkState(inBuffer.position() >= padding);
        if (inBuffer.position() == padding) {
            return;
        }
        inBuffer.flip();
        outBuffer.clear();
        decryptor.decrypt(inBuffer, outBuffer);
        inBuffer.clear();
        outBuffer.flip();
        if (padding > 0) {
            outBuffer.position(padding);
        }
    }

    private byte afterDecryption(Decryptor decryptor, ByteBuffer inBuffer, long position, byte[] iv) throws IOException {
        byte padding = 0;
        if (decryptor.isContextReset()) {
            this.updateDecryptor(decryptor, position, iv);
            padding = this.getPadding(position);
            inBuffer.position(padding);
        }
        return padding;
    }

    private long getCounter(long position) {
        return position / (long)this.codec.getCipherSuite().getAlgorithmBlockSize();
    }

    private byte getPadding(long position) {
        return (byte)(position % (long)this.codec.getCipherSuite().getAlgorithmBlockSize());
    }

    private void updateDecryptor(Decryptor decryptor, long position, byte[] iv) throws IOException {
        long counter = this.getCounter(position);
        this.codec.calculateIV(this.initIV, counter, iv);
        decryptor.init(this.key, iv);
    }

    private void resetStreamOffset(long offset) throws IOException {
        this.streamOffset = offset;
        this.inBuffer.clear();
        this.outBuffer.clear();
        this.outBuffer.limit(0);
        this.updateDecryptor(this.decryptor, offset, this.iv);
        this.padding = this.getPadding(offset);
        this.inBuffer.position(this.padding);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.freeBuffers();
        this.codec.close();
        this.closed = true;
    }

    @Override
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkStream();
        try {
            int n = ((PositionedReadable)((Object)this.in)).read(position, buffer, offset, length);
            if (n > 0) {
                this.decrypt(position, buffer, offset, n);
            }
            return n;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support positioned read.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrypt(long position, byte[] buffer, int offset, int length) throws IOException {
        ByteBuffer inBuffer = this.getBuffer();
        ByteBuffer outBuffer = this.getBuffer();
        Decryptor decryptor = null;
        try {
            decryptor = this.getDecryptor();
            byte[] iv = (byte[])this.initIV.clone();
            this.updateDecryptor(decryptor, position, iv);
            byte padding = this.getPadding(position);
            inBuffer.position(padding);
            int n = 0;
            while (n < length) {
                int toDecrypt = Math.min(length - n, inBuffer.remaining());
                inBuffer.put(buffer, offset + n, toDecrypt);
                this.decrypt(decryptor, inBuffer, outBuffer, padding);
                outBuffer.get(buffer, offset + n, toDecrypt);
                padding = this.afterDecryption(decryptor, inBuffer, position + (long)(n += toDecrypt), iv);
            }
        }
        finally {
            this.returnBuffer(inBuffer);
            this.returnBuffer(outBuffer);
            this.returnDecryptor(decryptor);
        }
    }

    @Override
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkStream();
        try {
            ((PositionedReadable)((Object)this.in)).readFully(position, buffer, offset, length);
            if (length > 0) {
                this.decrypt(position, buffer, offset, length);
            }
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support positioned readFully.");
        }
    }

    @Override
    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        this.checkStream();
        try {
            if (pos <= this.streamOffset && pos >= this.streamOffset - (long)this.outBuffer.remaining()) {
                int forward = (int)(pos - (this.streamOffset - (long)this.outBuffer.remaining()));
                if (forward > 0) {
                    this.outBuffer.position(this.outBuffer.position() + forward);
                }
            } else {
                ((Seekable)((Object)this.in)).seek(pos);
                this.resetStreamOffset(pos);
            }
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support seek.");
        }
    }

    @Override
    public long skip(long n) throws IOException {
        Preconditions.checkArgument(n >= 0L, "Negative skip length.");
        this.checkStream();
        if (n == 0L) {
            return 0L;
        }
        if (n <= (long)this.outBuffer.remaining()) {
            int pos = this.outBuffer.position() + (int)n;
            this.outBuffer.position(pos);
            return n;
        }
        long skipped = this.in.skip(n -= (long)this.outBuffer.remaining());
        if (skipped < 0L) {
            skipped = 0L;
        }
        long pos = this.streamOffset + skipped;
        this.resetStreamOffset(pos);
        return skipped += (long)this.outBuffer.remaining();
    }

    @Override
    public long getPos() throws IOException {
        this.checkStream();
        return this.streamOffset - (long)this.outBuffer.remaining();
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        this.checkStream();
        if (this.isByteBufferReadable || this.isReadableByteChannel) {
            int n;
            int unread = this.outBuffer.remaining();
            if (unread > 0) {
                int toRead = buf.remaining();
                if (toRead <= unread) {
                    int limit = this.outBuffer.limit();
                    this.outBuffer.limit(this.outBuffer.position() + toRead);
                    buf.put(this.outBuffer);
                    this.outBuffer.limit(limit);
                    return toRead;
                }
                buf.put(this.outBuffer);
            }
            int pos = buf.position();
            int n2 = n = this.isByteBufferReadable ? ((ByteBufferReadable)((Object)this.in)).read(buf) : ((ReadableByteChannel)((Object)this.in)).read(buf);
            if (n > 0) {
                this.streamOffset += (long)n;
                this.decrypt(buf, n, pos);
            }
            if (n >= 0) {
                return unread + n;
            }
            if (unread == 0) {
                return -1;
            }
            return unread;
        }
        int n = 0;
        if (buf.hasArray()) {
            n = this.read(buf.array(), buf.position(), buf.remaining());
            if (n > 0) {
                buf.position(buf.position() + n);
            }
        } else {
            byte[] tmp = new byte[buf.remaining()];
            n = this.read(tmp);
            if (n > 0) {
                buf.put(tmp, 0, n);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrypt(ByteBuffer buf, int n, int start) throws IOException {
        int pos = buf.position();
        int limit = buf.limit();
        int len = 0;
        while (len < n) {
            buf.position(start + len);
            buf.limit(start + len + Math.min(n - len, this.inBuffer.remaining()));
            this.inBuffer.put(buf);
            try {
                this.decrypt(this.decryptor, this.inBuffer, this.outBuffer, this.padding);
                buf.position(start + len);
                buf.limit(limit);
                len += this.outBuffer.remaining();
                buf.put(this.outBuffer);
            }
            finally {
                this.padding = this.afterDecryption(this.decryptor, this.inBuffer, this.streamOffset - (long)(n - len), this.iv);
            }
        }
        buf.position(pos);
    }

    @Override
    public int available() throws IOException {
        this.checkStream();
        return this.in.available() + this.outBuffer.remaining();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark/reset not supported");
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        Preconditions.checkArgument(targetPos >= 0L, "Cannot seek to negative offset.");
        this.checkStream();
        try {
            boolean result = ((Seekable)((Object)this.in)).seekToNewSource(targetPos);
            this.resetStreamOffset(targetPos);
            return result;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support seekToNewSource.");
        }
    }

    @Override
    public ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        this.checkStream();
        try {
            int n;
            ByteBuffer buffer;
            if (this.outBuffer.remaining() > 0) {
                ((Seekable)((Object)this.in)).seek(this.getPos());
                this.resetStreamOffset(this.getPos());
            }
            if ((buffer = ((HasEnhancedByteBufferAccess)((Object)this.in)).read(bufferPool, maxLength, opts)) != null && (n = buffer.remaining()) > 0) {
                this.streamOffset += (long)buffer.remaining();
                int pos = buffer.position();
                this.decrypt(buffer, n, pos);
            }
            return buffer;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support enhanced byte buffer access.");
        }
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        try {
            ((HasEnhancedByteBufferAccess)((Object)this.in)).releaseBuffer(buffer);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support release buffer.");
        }
    }

    @Override
    public void setReadahead(Long readahead) throws IOException, UnsupportedOperationException {
        try {
            ((CanSetReadahead)((Object)this.in)).setReadahead(readahead);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support setting the readahead caching strategy.");
        }
    }

    @Override
    public void setDropBehind(Boolean dropCache) throws IOException, UnsupportedOperationException {
        try {
            ((CanSetDropBehind)((Object)this.in)).setDropBehind(dropCache);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support setting the drop-behind caching setting.");
        }
    }

    @Override
    public FileDescriptor getFileDescriptor() throws IOException {
        if (this.in instanceof HasFileDescriptor) {
            return ((HasFileDescriptor)((Object)this.in)).getFileDescriptor();
        }
        if (this.in instanceof FileInputStream) {
            return ((FileInputStream)this.in).getFD();
        }
        return null;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.oneByteBuf, 0, 1) == -1 ? -1 : this.oneByteBuf[0] & 0xFF;
    }

    private void checkStream() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    private ByteBuffer getBuffer() {
        ByteBuffer buffer = this.bufferPool.poll();
        if (buffer == null) {
            buffer = ByteBuffer.allocateDirect(this.bufferSize);
        }
        return buffer;
    }

    private void returnBuffer(ByteBuffer buf) {
        if (buf != null) {
            buf.clear();
            this.bufferPool.add(buf);
        }
    }

    private void freeBuffers() {
        CryptoStreamUtils.freeDB(this.inBuffer);
        CryptoStreamUtils.freeDB(this.outBuffer);
        this.cleanBufferPool();
    }

    private void cleanBufferPool() {
        ByteBuffer buf;
        while ((buf = this.bufferPool.poll()) != null) {
            CryptoStreamUtils.freeDB(buf);
        }
    }

    private Decryptor getDecryptor() throws IOException {
        Decryptor decryptor = this.decryptorPool.poll();
        if (decryptor == null) {
            try {
                decryptor = this.codec.createDecryptor();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
        return decryptor;
    }

    private void returnDecryptor(Decryptor decryptor) {
        if (decryptor != null) {
            this.decryptorPool.add(decryptor);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    private void cleanDecryptorPool() {
        this.decryptorPool.clear();
    }

    @Override
    public void unbuffer() {
        this.cleanBufferPool();
        this.cleanDecryptorPool();
        StreamCapabilitiesPolicy.unbuffer(this.in);
    }

    @Override
    public boolean hasCapability(String capability) {
        switch (StringUtils.toLowerCase(capability)) {
            case "in:readahead": 
            case "dropbehind": 
            case "in:unbuffer": {
                return true;
            }
        }
        return false;
    }
}

