/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import io.prestosql.hadoop.$internal.com.google.common.base.Joiner;
import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;

public class RemoteEditLogManifest {
    private List<RemoteEditLog> logs;
    private long committedTxnId = -12345L;

    public RemoteEditLogManifest() {
    }

    public RemoteEditLogManifest(List<RemoteEditLog> logs) {
        this(logs, -12345L);
    }

    public RemoteEditLogManifest(List<RemoteEditLog> logs, long committedTxnId) {
        this.logs = logs;
        this.committedTxnId = committedTxnId;
        this.checkState();
    }

    private void checkState() {
        Preconditions.checkNotNull(this.logs);
        RemoteEditLog prev = null;
        for (RemoteEditLog log : this.logs) {
            if (prev != null && log.getStartTxId() <= prev.getEndTxId()) {
                throw new IllegalStateException("Invalid log manifest (log " + log + " overlaps " + prev + ")\n" + this);
            }
            prev = log;
        }
    }

    public List<RemoteEditLog> getLogs() {
        return Collections.unmodifiableList(this.logs);
    }

    public long getCommittedTxnId() {
        return this.committedTxnId;
    }

    public String toString() {
        return "[" + Joiner.on(", ").join(this.logs) + "] CommittedTxId: " + this.committedTxnId;
    }
}

