/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.com.codahale.metrics.jvm;

import io.prestosql.hive.$internal.com.codahale.metrics.Gauge;
import io.prestosql.hive.$internal.com.codahale.metrics.Metric;
import io.prestosql.hive.$internal.com.codahale.metrics.MetricRegistry;
import io.prestosql.hive.$internal.com.codahale.metrics.MetricSet;
import io.prestosql.hive.$internal.com.codahale.metrics.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MemoryUsageGaugeSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public MemoryUsageGaugeSet() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryUsageGaugeSet(MemoryMXBean mxBean, Collection<MemoryPoolMXBean> memoryPools) {
        this.mxBean = mxBean;
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(memoryPools);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge<Long>> gauges = new HashMap<String, Gauge<Long>>();
        gauges.put("total.init", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getInit() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getInit();
            }
        });
        gauges.put("total.used", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getUsed() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        gauges.put("total.max", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getMax() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        gauges.put("total.committed", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getCommitted() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put("heap.init", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getInit();
            }
        });
        gauges.put("heap.used", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getUsed();
            }
        });
        gauges.put("heap.max", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getMax();
            }
        });
        gauges.put("heap.committed", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put("heap.usage", new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax());
            }
        });
        gauges.put("non-heap.init", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getInit();
            }
        });
        gauges.put("non-heap.used", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        gauges.put("non-heap.max", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        gauges.put("non-heap.committed", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put("non-heap.usage", new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax());
            }
        });
        for (final MemoryPoolMXBean pool : this.memoryPools) {
            gauges.put(MetricRegistry.name("pools", WHITESPACE.matcher(pool.getName()).replaceAll("-"), "usage"), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    long max = pool.getUsage().getMax() == -1L ? pool.getUsage().getCommitted() : pool.getUsage().getMax();
                    return RatioGauge.Ratio.of(pool.getUsage().getUsed(), max);
                }
            });
        }
        return Collections.unmodifiableMap(gauges);
    }
}

