/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.com.fasterxml.jackson.databind.deser.impl;

import io.prestosql.hive.$internal.com.fasterxml.jackson.core.JsonParser;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.DeserializationContext;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.JavaType;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.JsonDeserializer;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.PropertyName;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.util.Annotations;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public final class FieldProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedField _annotated;
    protected final transient Field _field;

    public FieldProperty(BeanPropertyDefinition propDef, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedField field) {
        super(propDef, type, typeDeser, contextAnnotations);
        this._annotated = field;
        this._field = field.getAnnotated();
    }

    protected FieldProperty(FieldProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._annotated = src._annotated;
        this._field = src._field;
    }

    protected FieldProperty(FieldProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._annotated = src._annotated;
        this._field = src._field;
    }

    protected FieldProperty(FieldProperty src) {
        super(src);
        this._annotated = src._annotated;
        Field f = this._annotated.getAnnotated();
        if (f == null) {
            throw new IllegalArgumentException("Missing field (broken JDK (de)serialization?)");
        }
        this._field = f;
    }

    @Override
    public FieldProperty withName(PropertyName newName) {
        return new FieldProperty(this, newName);
    }

    @Override
    public FieldProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new FieldProperty(this, deser);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotated == null ? null : (A)this._annotated.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException {
        Object value = this.deserialize(jp, ctxt);
        try {
            this._field.set(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException {
        Object value = this.deserialize(jp, ctxt);
        try {
            this._field.set(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
        }
        return instance;
    }

    @Override
    public final void set(Object instance, Object value) throws IOException {
        try {
            this._field.set(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
        }
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        try {
            this._field.set(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
        }
        return instance;
    }

    Object readResolve() {
        return new FieldProperty(this);
    }
}

