/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.com.fasterxml.jackson.databind.exc;

import io.prestosql.hive.$internal.com.fasterxml.jackson.core.JsonLocation;
import io.prestosql.hive.$internal.com.fasterxml.jackson.core.JsonParser;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.exc.PropertyBindingException;
import java.util.Collection;

public class UnrecognizedPropertyException
extends PropertyBindingException {
    private static final long serialVersionUID = 1L;

    public UnrecognizedPropertyException(String msg, JsonLocation loc, Class<?> referringClass, String propName, Collection<Object> propertyIds) {
        super(msg, loc, referringClass, propName, propertyIds);
    }

    public static UnrecognizedPropertyException from(JsonParser jp, Object fromObjectOrClass, String propertyName, Collection<Object> propertyIds) {
        if (fromObjectOrClass == null) {
            throw new IllegalArgumentException();
        }
        Class<?> ref = fromObjectOrClass instanceof Class ? (Class<?>)fromObjectOrClass : fromObjectOrClass.getClass();
        String msg = "Unrecognized field \"" + propertyName + "\" (class " + ref.getName() + "), not marked as ignorable";
        UnrecognizedPropertyException e = new UnrecognizedPropertyException(msg, jp.getCurrentLocation(), ref, propertyName, propertyIds);
        e.prependPath(fromObjectOrClass, propertyName);
        return e;
    }

    @Deprecated
    public String getUnrecognizedPropertyName() {
        return this.getPropertyName();
    }
}

